/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.utils;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import red.honey.oss.annotation.SecondTrans;
import red.honey.oss.strategy.SecondTransStrategy;
import red.honey.oss.utils.ParserUtils;

public class AnnotationUtils {
    private static final Logger log = LoggerFactory.getLogger(AnnotationUtils.class);

    public static <A extends Annotation> boolean isPresent(Method method, Class<A> annotationClass) {
        return org.apache.dubbo.config.spring.util.AnnotationUtils.isPresent((Method)method, annotationClass);
    }

    public static <A extends Annotation> Annotation getAnnotation(Method method, Class<A> annotationClass) {
        return org.springframework.core.annotation.AnnotationUtils.getAnnotation((Method)method, annotationClass);
    }

    public static <A extends Annotation> Annotation getAnnotation(Annotation annotation, Class<A> annotationClass) {
        return org.springframework.core.annotation.AnnotationUtils.getAnnotation((Annotation)annotation, annotationClass);
    }

    public static String resolvePlaceholders(String attributeValue, PropertyResolver propertyResolver) {
        String resolvedValue = attributeValue;
        if (propertyResolver != null) {
            resolvedValue = propertyResolver.resolvePlaceholders(attributeValue);
            resolvedValue = StringUtils.trimWhitespace((String)resolvedValue);
        }
        return resolvedValue;
    }

    public static Method getMethod(ProceedingJoinPoint jointPoint) {
        return ((MethodSignature)jointPoint.getSignature()).getMethod();
    }

    public static boolean hasAnnotation(ProceedingJoinPoint jointPoint, Class<? extends Annotation> clazz) {
        Annotation annotation = AnnotationUtils.getAnnotation(jointPoint, clazz);
        return annotation != null;
    }

    public static Annotation getAnnotation(ProceedingJoinPoint jointPoint, Class<? extends Annotation> clazz) {
        Method method = ((MethodSignature)jointPoint.getSignature()).getMethod();
        return method.getAnnotation(clazz);
    }

    public static Map<String, Object> resolvePlaceholders(Map<String, Object> sourceAnnotationAttributes, PropertyResolver propertyResolver, String ... ignoreAttributeNames) {
        return org.apache.dubbo.config.spring.util.AnnotationUtils.resolvePlaceholders(sourceAnnotationAttributes, (PropertyResolver)propertyResolver, (String[])ignoreAttributeNames);
    }

    public static Map<String, Object> resolveSpel(Map<String, Object> sourceAnnotationAttributes, ProceedingJoinPoint joinPoint) {
        HashMap<String, Object> temp = new HashMap<String, Object>(sourceAnnotationAttributes.size());
        sourceAnnotationAttributes.forEach((key, value) -> {
            if (value instanceof String) {
                if (ParserUtils.isSpelExpression((String)value)) {
                    String spel = ParserUtils.parseSpel((String)value, joinPoint);
                    temp.put((String)key, spel);
                } else {
                    temp.put((String)key, value);
                }
            }
        });
        return temp;
    }

    public static File getFile(ProceedingJoinPoint jointPoint) {
        Object[] arguments = jointPoint.getArgs();
        return (File)Arrays.stream(arguments).filter(e -> e instanceof File).findFirst().orElseGet(() -> new File((String)arguments[0]));
    }

    public static boolean conditionOnSecondTrans(ProceedingJoinPoint jointPoint, ApplicationContext applicationContext, Environment environment) {
        boolean secondTrans = AnnotationUtils.hasAnnotation(jointPoint, SecondTrans.class);
        if (secondTrans) {
            SecondTransStrategy strategyBean;
            SecondTrans annotation = (SecondTrans)AnnotationUtils.getAnnotation(jointPoint, SecondTrans.class);
            Class<? extends SecondTransStrategy> clazz = annotation.value();
            String bucketName = annotation.bucketName();
            String bucketNameValue = ParserUtils.parseSpel(bucketName, jointPoint);
            if (bucketNameValue.equals(bucketName)) {
                bucketNameValue = AnnotationUtils.resolvePlaceholders(bucketName, (PropertyResolver)environment);
            }
            try {
                strategyBean = (SecondTransStrategy)applicationContext.getBean(clazz);
            }
            catch (NoUniqueBeanDefinitionException nue) {
                throw nue;
            }
            catch (NoSuchBeanDefinitionException e) {
                strategyBean = (SecondTransStrategy)applicationContext.getBean(SecondTransStrategy.class);
            }
            File file = AnnotationUtils.getFile(jointPoint);
            boolean condition = strategyBean.conditionOnSecondTrans(bucketNameValue, file);
            if (condition) {
                log.debug("\u79d2\u4f20\u6210\u529f,\u4f7f\u7528\u7684\u79d2\u4f20\u7b56\u7565\uff1a{}", clazz);
                return true;
            }
        }
        return false;
    }
}

