/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import red.honey.oss.api.dto.FileDto;
import red.honey.oss.api.dto.HoneyStream;
import red.honey.oss.api.utils.HoneyFileUtil;

public class BeanConverter {
    private static final Logger log = LoggerFactory.getLogger(BeanConverter.class);

    public static <S, T> T convert(S source, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            BeanUtils.copyProperties(source, instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("bean convert fail");
        }
    }

    public static <T, S> List<T> convertByList(List<S> source, Class<T> clazz) {
        ArrayList<T> ts = new ArrayList<T>();
        for (S s : source) {
            ts.add(BeanConverter.convert(s, clazz));
        }
        return ts;
    }

    public static FileDto convert2FileDto(File file) {
        FileDto fileDto = new FileDto();
        try {
            FileInputStream inputStream = FileUtils.openInputStream((File)file);
            FileInputStream inputStreamTemp = FileUtils.openInputStream((File)file);
            fileDto.setUid(HoneyFileUtil.get32Uid());
            HoneyStream honeyStream = new HoneyStream((InputStream)inputStream);
            fileDto.setHoneyStream(honeyStream);
            String fileName = file.getName();
            fileDto.setFileName(fileName);
            String fileKey = HoneyFileUtil.getFileKey((InputStream)inputStreamTemp);
            fileDto.setFileKey(fileKey);
            String fileSuffix = HoneyFileUtil.getFileSuffix((String)fileName);
            fileDto.setFileSuffix(fileSuffix);
            long fileSize = HoneyFileUtil.getFileSize((FileInputStream)inputStream);
            fileDto.setFileSize(fileSize);
            fileDto.setShardTotal(0);
            fileDto.setShardSize(0L);
            return fileDto;
        }
        catch (Exception e) {
            log.warn("SDK\u6784\u5efaFileDto\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

