/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.utils;

import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class ParserUtils {
    private static final String SPEL_SYMBOL = "#";

    public static String parseSpel(String input, ProceedingJoinPoint joinPoint) {
        if (ParserUtils.isSpelExpression(input)) {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
            String[] paramNames = nameDiscoverer.getParameterNames(methodSignature.getMethod());
            Expression expression = parser.parseExpression(input);
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < args.length; ++i) {
                context.setVariable(Objects.requireNonNull(paramNames)[i], args[i]);
            }
            return (String)expression.getValue((EvaluationContext)context, String.class);
        }
        return input;
    }

    public static boolean isSpelExpression(String str) {
        Assert.notNull((Object)str, (String)"the str will be check is SPEL must not null");
        return str.contains(SPEL_SYMBOL);
    }
}

