/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.component;

import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.RedisTemplate;
import red.honey.redis.entiy.PositionInfo;

public class HoneyGeo {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public void addGeoBean(String key, List<PositionInfo> positionInfos) {
        HashSet locations = new HashSet();
        positionInfos.forEach(ci -> locations.add(new RedisGeoCommands.GeoLocation((Object)ci.getMember(), new Point(ci.getLongitude().doubleValue(), ci.getLatitude().doubleValue()))));
        this.redisTemplate.opsForGeo().add((Object)key, locations);
    }

    public void removeGeoBean(String key, Object ... member) {
        this.redisTemplate.opsForZSet().remove((Object)key, member);
    }

    public List<Point> getPosition(String key, String ... member) {
        return this.redisTemplate.opsForGeo().position((Object)key, (Object[])member);
    }

    public Distance distance(String key, String source, String dest, Metric metric) {
        return this.redisTemplate.opsForGeo().distance((Object)key, (Object)source, (Object)dest, metric);
    }

    public Distance distance(String key, String source, String dest) {
        return this.redisTemplate.opsForGeo().distance((Object)key, (Object)source, (Object)dest);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> near(String key, double longitude, double latitude, long radius, long limit) {
        return this.near(key, longitude, latitude, radius, null, limit);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> near(String key, double longitude, double latitude, long radius, Metric metric, long limit) {
        if (metric == null) {
            metric = Metrics.KILOMETERS;
        }
        Circle circle = new Circle(longitude, latitude, (double)radius * metric.getMultiplier());
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates().sortAscending().limit(limit);
        return this.redisTemplate.opsForGeo().radius((Object)key, circle, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> nearByPlace(String key, String member, long radius, long limit) {
        return this.nearByPlace(key, member, radius, null, limit);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> nearByPlace(String key, String member, long radius, Metric metric, long limit) {
        if (metric == null) {
            metric = Metrics.KILOMETERS;
        }
        Distance distance = new Distance((double)radius, metric);
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates().sortAscending().limit(limit);
        return this.redisTemplate.opsForGeo().radius((Object)key, (Object)member, distance, args);
    }

    public List<String> geoHash(String key, String ... members) {
        return this.redisTemplate.opsForGeo().hash((Object)key, (Object[])members);
    }
}

