/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.component;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class HoneyRedis {
    private static final Logger log = LoggerFactory.getLogger(HoneyRedis.class);
    private final String LOG_PATTERN = "honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]";
    private final long expireTime = 500L;
    private final long expireAt = System.currentTimeMillis() + 500L;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"expire", argsStr, e.getMessage()});
            return false;
        }
    }

    public long getExpire(String key) {
        Assert.notNull((Object)key, (String)"key not null");
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"hasKey", argsStr, e.getMessage()});
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"set", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"set", argsStr, e.getMessage()});
            return false;
        }
    }

    public Long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "map", map);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"hmset", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "map", map, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"hmset", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "item", item, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"hset", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "item", item, "value", value, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"hset", argsStr, e.getMessage()});
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"sGet", argsStr, e.getMessage()});
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"sHasKey", argsStr, e.getMessage()});
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "values", values);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"sSet", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "time", time, "values", values);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"sSetAndTime", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"sGetSetSize", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "values", values);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"setRemove", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "start", start, "end", end);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lGet", argsStr, e.getMessage()});
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lGetListSize", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "index", index);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lGetIndex", argsStr, e.getMessage()});
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lSet", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lSet", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lSet", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value, "time", time);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lSet", argsStr, e.getMessage()});
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "index", index, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lUpdateIndex", argsStr, e.getMessage()});
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            String argsStr = this.convertArgsStr("key", key, "value", value);
            log.warn("honey-redis:[ \u65b9\u6cd5\uff1a{}\uff1b\u53c2\u6570\uff1a{}\uff1b\u5f02\u5e38\u539f\u56e0\uff1a{}]", new Object[]{"lRemove", argsStr, e.getMessage()});
            return 0L;
        }
    }

    public boolean isReqDuplicate(String userId, String method, String deDuplicateParam) {
        String KEY = "deDuplicate:U=" + userId + "M=" + method + "P=" + deDuplicateParam;
        return this.isReqDuplicate(KEY);
    }

    public boolean isReqDuplicate(String key) {
        String val = "expireAt@" + this.expireAt;
        Boolean firstSet = (Boolean)this.stringRedisTemplate.execute(connection -> connection.set(key.getBytes(), val.getBytes(), Expiration.milliseconds((long)500L), RedisStringCommands.SetOption.SET_IF_ABSENT));
        boolean isConsiderDup = firstSet == null || firstSet == false;
        return isConsiderDup;
    }

    private String convertArgsStr(Object ... args) {
        StringBuilder builder = new StringBuilder();
        Arrays.stream(args).forEach(arg -> builder.append(arg).append(":"));
        return String.valueOf(builder.deleteCharAt(builder.length() - 1));
    }
}

