/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import red.honey.redis.component.HoneyRedis;

public final class HoneyRedisId {
    private final String GLOBALLY_UNIQUE_ID_KEY = "GLOBALLY_UNIQUE_ID_KEY";
    @Autowired
    private HoneyRedis honeyRedis;

    public String getGloballyUniqueId() {
        long delta = 1L;
        Long incr = this.honeyRedis.incr("GLOBALLY_UNIQUE_ID_KEY", delta);
        return this.currentDateTime() + String.format("%1$05d", incr);
    }

    public String getGloballyUniqueId(String preFix) {
        return preFix + this.getGloballyUniqueId();
    }

    public String getGloballyUniqueId(String preFix, long delta) {
        Long incr = this.honeyRedis.incr("GLOBALLY_UNIQUE_ID_KEY", delta);
        return preFix + this.currentDateTime() + String.format("%1$05d", incr);
    }

    private String currentDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return dateTimeFormatter.format(localDateTime);
    }
}

