/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.component;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.redis.util.RedisLockRegistry;

public final class HoneyRedisLock {
    private static final Logger log = LoggerFactory.getLogger(HoneyRedisLock.class);
    private static final long DEFAULT_EXPIRE_UNUSED = 60000L;
    private final RedisLockRegistry redisLockRegistry;

    public void lock(String lockKey) {
        this.obtainLock(lockKey).lock();
    }

    public boolean tryLock(String lockKey) {
        Lock lock = this.obtainLock(lockKey);
        return lock.tryLock();
    }

    public boolean tryLock(String lockKey, long seconds) {
        Lock lock = this.obtainLock(lockKey);
        try {
            return lock.tryLock(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void unlock(String lockKey) {
        try {
            Lock lock = this.obtainLock(lockKey);
            lock.unlock();
            this.redisLockRegistry.expireUnusedOlderThan(60000L);
        }
        catch (Exception e) {
            log.error("\u5206\u5e03\u5f0f\u9501 [{}] \u91ca\u653e\u5f02\u5e38", (Object)lockKey, (Object)e);
        }
    }

    public void unlock(String lockKey, long keyExpireTime) {
        try {
            Lock lock = this.obtainLock(lockKey);
            lock.unlock();
            this.redisLockRegistry.expireUnusedOlderThan(keyExpireTime);
        }
        catch (Exception e) {
            log.error("\u5206\u5e03\u5f0f\u9501 [{}] \u91ca\u653e\u5f02\u5e38", (Object)lockKey, (Object)e);
        }
    }

    private Lock obtainLock(String lockKey) {
        return this.redisLockRegistry.obtain((Object)lockKey);
    }

    public HoneyRedisLock(RedisLockRegistry redisLockRegistry) {
        this.redisLockRegistry = redisLockRegistry;
    }
}

