/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.redis.util.RedisLockRegistry;
import red.honey.redis.component.HoneyGeo;
import red.honey.redis.component.HoneyRedis;
import red.honey.redis.component.HoneyRedisId;
import red.honey.redis.component.HoneyRedisLock;
import red.honey.redis.config.RedisConfig;
import red.honey.redis.config.RedisLockConfig;

@Configuration
@EnableConfigurationProperties(value={RedisProperties.class})
@ConditionalOnClass(value={HoneyRedis.class, HoneyRedisId.class, HoneyRedisLock.class})
@Import(value={RedisConfig.class, RedisLockConfig.class})
public class RedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HoneyGeo honeyGeo() {
        return new HoneyGeo();
    }

    @Bean
    @ConditionalOnMissingBean
    public HoneyRedis honeyRedis() {
        return new HoneyRedis();
    }

    @Bean
    @ConditionalOnMissingBean
    public HoneyRedisId honeyRedisId() {
        return new HoneyRedisId();
    }

    @Bean
    @ConditionalOnMissingBean
    public HoneyRedisLock honeyRedisLock(RedisLockRegistry redisLockRegistry) {
        return new HoneyRedisLock(redisLockRegistry);
    }
}

