/*
 * Decompiled with CFR 0.152.
 */
package red.honey.redis.utils;

import com.alibaba.fastjson.JSON;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqDeduplicateHelper {
    private static final Logger log = LoggerFactory.getLogger(ReqDeduplicateHelper.class);

    private static String genMD5(String src) {
        String res;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] mdBytes = messageDigest.digest(src.getBytes());
            res = DatatypeConverter.printHexBinary((byte[])mdBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("MD5 hash happen error,the reason :" + e.getMessage());
        }
        return res;
    }

    public String deDuplicateParam(String reqJSON, String ... excludeKeys) {
        List<String> deDuplicateExcludeKeys;
        TreeMap paramTreeMap = (TreeMap)JSON.parseObject((String)reqJSON, TreeMap.class);
        if (excludeKeys != null && !(deDuplicateExcludeKeys = Arrays.asList(excludeKeys)).isEmpty()) {
            for (String deDuplicateExcludeKey : deDuplicateExcludeKeys) {
                paramTreeMap.remove(deDuplicateExcludeKey);
            }
        }
        String paramTreeMapJSON = JSON.toJSONString((Object)paramTreeMap);
        String md5deDupParam = ReqDeduplicateHelper.genMD5(paramTreeMapJSON);
        if (log.isDebugEnabled()) {
            log.debug("md5deDupParam = {}, excludeKeys = {} {}", new Object[]{md5deDupParam, Arrays.deepToString(excludeKeys), paramTreeMapJSON});
        }
        return md5deDupParam;
    }
}

