/*
 * Decompiled with CFR 0.152.
 */
package com.eboy.honey.response.autoconfigure.config;

import com.eboy.honey.response.constant.HoneyArgsExceptionException;
import com.eboy.honey.response.constant.HoneyCommonExceptionException;
import com.eboy.honey.response.constant.HoneyServletExceptionException;
import com.eboy.honey.response.constant.HoneyUCExceptionException;
import com.eboy.honey.response.core.HoneyEnvConfig;
import com.eboy.honey.response.core.HoneyExceptionHandler;
import com.eboy.honey.response.core.HoneyMessage;
import com.eboy.honey.response.core.impl.DefaultHoneyMessage;
import com.eboy.honey.response.core.impl.HoneyDefaultEnvConfig;
import com.eboy.honey.response.handler.HoneyExceptionDefaultHandler;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
@ConditionalOnClass(value={HoneyArgsExceptionException.class, HoneyCommonExceptionException.class, HoneyServletExceptionException.class, HoneyUCExceptionException.class})
public class HoneyAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HoneyAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={HoneyExceptionHandler.class})
    public HoneyExceptionDefaultHandler honeyExceptionHandler() {
        log.info("honey-response\u9ed8\u8ba4\u7684HoneyExceptionDefaultHandler\u81ea\u52a8\u88c5\u914d\u5b8c\u6210");
        return new HoneyExceptionDefaultHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={HoneyEnvConfig.class})
    public HoneyEnvConfig honeyEnvConfig() {
        log.info("honey-response\u9ed8\u8ba4\u7684HoneyEnvConfig\u81ea\u52a8\u88c5\u914d\u5b8c\u6210");
        return new HoneyDefaultEnvConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={HoneyMessage.class})
    public DefaultHoneyMessage honeyMessage() {
        log.info("honey-response\u9ed8\u8ba4\u7684honeyMessage\u81ea\u52a8\u88c5\u914d\u5b8c\u6210");
        return new DefaultHoneyMessage();
    }

    @Bean(value={"messageSource"})
    @ConditionalOnMissingBean(value={MessageSource.class})
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"/i18n/messages"});
        messageSource.setDefaultEncoding(StandardCharsets.UTF_8.name());
        messageSource.setUseCodeAsDefaultMessage(true);
        messageSource.setFallbackToSystemLocale(false);
        log.info("honey-response \u81ea\u52a8\u88c5\u914d messageSource\u5b8c\u6210");
        return messageSource;
    }
}

