/*
 * Decompiled with CFR 0.152.
 */
package com.eboy.honey.response.handler;

import com.ctrip.framework.foundation.internals.provider.DefaultServerProvider;
import com.eboy.honey.response.autoconfigure.config.HoneyEnvConfigProperties;
import com.eboy.honey.response.commmon.HoneyErrorResponse;
import com.eboy.honey.response.constant.HoneyArgsExceptionException;
import com.eboy.honey.response.constant.HoneyCommonExceptionException;
import com.eboy.honey.response.constant.HoneyServletExceptionException;
import com.eboy.honey.response.core.HoneyEnvConfig;
import com.eboy.honey.response.core.HoneyExceptionHandler;
import com.eboy.honey.response.core.HoneyMessage;
import com.eboy.honey.response.exception.HoneyBaseException;
import com.eboy.honey.response.exception.HoneyBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ConditionalOnWebApplication
public class HoneyExceptionDefaultHandler
implements HoneyExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(HoneyExceptionDefaultHandler.class);
    @Autowired
    private HoneyMessage honeyMessage;
    @Autowired
    private HoneyEnvConfig honeyEnvConfig;

    private HoneyEnvConfigProperties getHoneyEnvConfig() {
        return this.honeyEnvConfig.setHoneyEnvConfig();
    }

    private String getSystemEnv() {
        if (this.getHoneyEnvConfig().isEnableApollo()) {
            DefaultServerProvider provider = new DefaultServerProvider();
            provider.initialize();
            return provider.getEnvType();
        }
        return this.getHoneyEnvConfig().getEnv();
    }

    @Override
    @ExceptionHandler(value={HoneyBusinessException.class})
    @ResponseBody
    public HoneyErrorResponse handleBusinessException(HoneyBaseException e) {
        log.warn(e.getMessage(), (Throwable)e);
        return new HoneyErrorResponse(e.getResponseEnum().getCode(), this.honeyMessage.getMessage(e));
    }

    @Override
    @ExceptionHandler(value={HoneyBaseException.class})
    @ResponseBody
    public HoneyErrorResponse handleBaseException(HoneyBaseException e) {
        log.warn(e.getMessage(), (Throwable)e);
        return new HoneyErrorResponse(e.getResponseEnum().getCode(), this.honeyMessage.getMessage(e));
    }

    @Override
    @ExceptionHandler(value={NoHandlerFoundException.class, HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, HttpMediaTypeNotAcceptableException.class, ServletRequestBindingException.class, ConversionNotSupportedException.class, MissingServletRequestPartException.class, AsyncRequestTimeoutException.class})
    @ResponseBody
    public HoneyErrorResponse handleServletException(Exception e) {
        log.warn(e.getMessage(), (Throwable)e);
        int code = HoneyServletExceptionException.WEB_UNKNOWN_ERROR.getCode();
        try {
            HoneyServletExceptionException servletExceptionEnum = HoneyServletExceptionException.valueOf(e.getClass().getSimpleName());
            code = servletExceptionEnum.getCode();
        }
        catch (IllegalArgumentException e1) {
            log.error("class [{}] not defined in enum {}", (Object)e.getClass().getName(), (Object)HoneyServletExceptionException.class.getName());
        }
        if (this.getHoneyEnvConfig().getEnvProd().equalsIgnoreCase(this.getSystemEnv())) {
            code = HoneyCommonExceptionException.SERVER_ERROR.getCode();
            HoneyBaseException honeyBaseException = new HoneyBaseException(HoneyServletExceptionException.PAGE_MISSING);
            String message = this.honeyMessage.getMessage(honeyBaseException);
            return new HoneyErrorResponse(code, message);
        }
        return new HoneyErrorResponse(code, e.getMessage());
    }

    @Override
    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public HoneyErrorResponse handleBindException(BindException e) {
        log.warn("\u53c2\u6570\u7ed1\u5b9a\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        return this.wrapperBindingResult(e.getBindingResult());
    }

    @Override
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public HoneyErrorResponse handleValidException(MethodArgumentNotValidException e) {
        log.warn("\u53c2\u6570\u7ed1\u5b9a\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        return this.wrapperBindingResult(e.getBindingResult());
    }

    private HoneyErrorResponse wrapperBindingResult(BindingResult bindingResult) {
        StringBuilder msg = new StringBuilder();
        for (ObjectError error : bindingResult.getAllErrors()) {
            msg.append(", ");
            if (error instanceof FieldError) {
                msg.append(((FieldError)error).getField()).append(": ");
            }
            msg.append(error.getDefaultMessage() == null ? "" : error.getDefaultMessage());
        }
        return new HoneyErrorResponse(HoneyArgsExceptionException.VALID_ERROR.getCode(), msg.substring(2));
    }

    @Override
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public HoneyErrorResponse handleException(Exception e) {
        log.warn(e.getMessage(), (Throwable)e);
        if (this.getHoneyEnvConfig().getEnvProd().equalsIgnoreCase(this.getSystemEnv())) {
            int code = HoneyCommonExceptionException.SERVER_ERROR.getCode();
            HoneyBaseException honeyBaseException = new HoneyBaseException(HoneyCommonExceptionException.SERVER_ERROR);
            String message = this.honeyMessage.getMessage(honeyBaseException);
            return new HoneyErrorResponse(code, message);
        }
        return new HoneyErrorResponse(HoneyCommonExceptionException.SERVER_ERROR.getCode(), e.getMessage());
    }

    public HoneyMessage getHoneyMessage() {
        return this.honeyMessage;
    }

    public void setHoneyMessage(HoneyMessage honeyMessage) {
        this.honeyMessage = honeyMessage;
    }

    public void setHoneyEnvConfig(HoneyEnvConfig honeyEnvConfig) {
        this.honeyEnvConfig = honeyEnvConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HoneyExceptionDefaultHandler)) {
            return false;
        }
        HoneyExceptionDefaultHandler other = (HoneyExceptionDefaultHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HoneyMessage this$honeyMessage = this.getHoneyMessage();
        HoneyMessage other$honeyMessage = other.getHoneyMessage();
        if (this$honeyMessage == null ? other$honeyMessage != null : !this$honeyMessage.equals(other$honeyMessage)) {
            return false;
        }
        HoneyEnvConfigProperties this$honeyEnvConfig = this.getHoneyEnvConfig();
        HoneyEnvConfigProperties other$honeyEnvConfig = other.getHoneyEnvConfig();
        return !(this$honeyEnvConfig == null ? other$honeyEnvConfig != null : !this$honeyEnvConfig.equals(other$honeyEnvConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HoneyExceptionDefaultHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HoneyMessage $honeyMessage = this.getHoneyMessage();
        result = result * 59 + ($honeyMessage == null ? 43 : $honeyMessage.hashCode());
        HoneyEnvConfigProperties $honeyEnvConfig = this.getHoneyEnvConfig();
        result = result * 59 + ($honeyEnvConfig == null ? 43 : $honeyEnvConfig.hashCode());
        return result;
    }

    public String toString() {
        return "HoneyExceptionDefaultHandler(honeyMessage=" + this.getHoneyMessage() + ", honeyEnvConfig=" + this.getHoneyEnvConfig() + ")";
    }
}

