/*
 * Decompiled with CFR 0.152.
 */
package red.honey.spring.context.support.config;

import com.alibaba.nacos.api.config.ConfigType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import red.honey.spring.context.support.annotation.EnableHoneySpringSupport;
import red.honey.spring.context.support.commom.ConfigCenterType;
import red.honey.spring.context.support.config.RefreshInjectedAnnotationBeanPostProcessor;
import red.honey.spring.context.support.entity.SpringConfig;

public class SpringConfigSupportRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = Collections.singleton(ClassUtils.getPackageName((String)metadata.getClassName()));
        SpringConfig springConfig = this.buildSpringConfig(metadata);
        this.registerSpringConfig(springConfig, registry);
        this.registerRefreshInjectedAnnotationBeanPostProcessor(packagesToScan, registry);
    }

    private void registerSpringConfig(SpringConfig springConfig, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(springConfig.getClass());
        builder.setRole(2);
        builder.addConstructorArgValue((Object)springConfig);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    private void registerRefreshInjectedAnnotationBeanPostProcessor(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(RefreshInjectedAnnotationBeanPostProcessor.class);
        builder.addConstructorArgValue(packagesToScan);
        builder.setRole(2);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    private SpringConfig buildSpringConfig(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableHoneySpringSupport.class.getName()));
        String groupId = attributes.getString("groupId");
        ConfigType type = (ConfigType)attributes.getEnum("type");
        Class converter = attributes.getClass("converter");
        ConfigCenterType centerType = (ConfigCenterType)attributes.getEnum("centerType");
        SpringConfig springConfig = new SpringConfig();
        springConfig.setGroupId(groupId);
        springConfig.setType(type);
        springConfig.setConverter(converter);
        springConfig.setCenterType(centerType);
        return springConfig;
    }
}

