/*
 * Decompiled with CFR 0.152.
 */
package red.honey.spring.context.support.listener;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import red.honey.spring.context.support.event.NacosReflectEvent;

public class NacosConfigListener
implements InitializingBean,
ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigListener.class);
    private ApplicationEventPublisher applicationEventPublisher;
    private NacosConfigManager nacosConfigManager;
    private String dataId;
    private String groupId;

    public NacosConfigListener(NacosConfigManager nacosConfigManager, String dataId, String groupId) {
        this.nacosConfigManager = nacosConfigManager;
        this.dataId = dataId;
        this.groupId = groupId;
    }

    public void afterPropertiesSet() throws NacosException {
        this.nacosConfigManager.getConfigService().addListener(this.dataId, this.groupId, new Listener(){

            public Executor getExecutor() {
                return null;
            }

            public void receiveConfigInfo(String configInfo) {
                NacosReflectEvent reflectEvent = new NacosReflectEvent(this, configInfo);
                NacosConfigListener.this.applicationEventPublisher.publishEvent((ApplicationEvent)reflectEvent);
            }
        });
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

