/*
 * Decompiled with CFR 0.152.
 */
package red.honey.spring.context.support.reflect;

import com.alibaba.nacos.api.config.convert.NacosConfigConverter;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import red.honey.spring.context.support.annotation.FieldRefresh;
import red.honey.spring.context.support.event.ApolloReflectEvent;
import red.honey.spring.context.support.event.NacosReflectEvent;
import red.honey.spring.context.support.factory.TargetClassFactory;

public class RefreshInjectedProcessor
implements ApplicationContextAware {
    private static Lock NACOS_LOCK = new ReentrantLock();
    private static Lock APOLLO_LCK = new ReentrantLock();
    private Logger log = LoggerFactory.getLogger(RefreshInjectedProcessor.class);
    private ApplicationContext applicationContext;
    private NacosConfigConverter<Map<String, String>> nacosConfigConverter;
    private volatile Map<String, String> configInfo;

    public RefreshInjectedProcessor() {
    }

    public RefreshInjectedProcessor(NacosConfigConverter<Map<String, String>> nacosConfigConverter) {
        this.nacosConfigConverter = nacosConfigConverter;
    }

    @Order
    @EventListener
    public void configChange(EnvironmentChangeEvent event) {
        Set keys = event.getKeys();
        ConcurrentHashSet<Class<?>> classes = TargetClassFactory.factory;
        this.doRefresh(keys, classes);
    }

    @Order(value=-2147483648)
    @EventListener(value={NacosReflectEvent.class})
    public void nacosReflect(NacosReflectEvent reflectEvent) {
        String configInfo = reflectEvent.getConfigInfo();
        this.configInfo = (Map)this.nacosConfigConverter.convert(configInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Order(value=-2147483648)
    @EventListener(value={ApolloReflectEvent.class})
    public void apolloReflect(ApolloReflectEvent reflectEvent) {
        ConfigChangeEvent changeEvent = reflectEvent.getChangeEvent();
        ConcurrentHashSet<Class<?>> classes = TargetClassFactory.factory;
        APOLLO_LCK.lock();
        try {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                for (Class clazz : classes) {
                    this.doRefresh(clazz, change.getPropertyName());
                }
            }
        }
        catch (Exception e) {
            this.log.error("APOLLO: Received the changeKeys for refreshing the Dependency injection", (Throwable)e);
        }
        finally {
            APOLLO_LCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(Set<String> keys, ConcurrentHashSet<Class<?>> classes) {
        NACOS_LOCK.lock();
        try {
            for (String changeKey : keys) {
                for (Class clazz : classes) {
                    this.doRefresh(clazz, changeKey);
                }
            }
        }
        catch (Exception e) {
            this.log.error("NACOS: Received the changeKeys for refreshing the Dependency injection", (Throwable)e);
        }
        finally {
            NACOS_LOCK.unlock();
        }
    }

    private void doRefresh(Class<?> clazz, String changeKey) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(FieldRefresh.class)) continue;
            field.setAccessible(true);
            FieldRefresh refresh = field.getAnnotation(FieldRefresh.class);
            String key = refresh.name();
            if (!changeKey.equals(key)) continue;
            String changeValue = this.configInfo.get(changeKey);
            Object bean = this.applicationContext.getBean(changeValue);
            Object curObject = this.applicationContext.getBean(clazz);
            field.set(curObject, bean);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

