package red.mulan.boot.common.code;

import lombok.AllArgsConstructor;
import lombok.Getter;
import red.mulan.boot.common.result.Result;

/**
 * 公共状态码<br>
 *
 * @author Max
 * @version 1.0.0
 * @since 2023/2/17 20:51
 */
@Getter
@AllArgsConstructor
public enum CommonCode implements Result {
    /**
     * 操作成功
     */
    SUCCESS("200",true,"success"),
    /**
     * 操作失败
     */
    FAIL("500",false,"fail"),
    /**
     * 系统错误
     */
    ERROR("-1",false,"error"),

    /**
     * 未授权
     */
    UNAUTHORIZED("401",false,"unauthorized"),
    /**
     * 权限不足
     */
    FORBIDDEN("403",false,"forbidden"),
    /**
     * 请求方式错误
     */
    REQUEST_METHOD_NOT_SUPPORTED("500",false,"request method not supported"),
    /**
     * 没有请求正文
     */
    REQUIRED_REQUEST_BODY_IS_MISSING("500",false,"required request body is missing"),

    /**
     * 用户名或者密码错误
     */
    USERNAME_OR_PASSWORD_ERROR("500",false,"username or password error"),
    ;

    /**
     * 自定义状态码
     */
    private final String code;
    /**
     * 自定义是否请求成功
     */
    private final boolean success;
    /**
     * 自定义提示信息
     */
    private final String message;


    /**
     * 返回自定义请求状态码
     * @return 返回自定义状态码
     */
    @Override
    public String code() {
        return this.code;
    }

    /**
     * 返回是否成功
     * @return 是否成功
     */
    @Override
    public Boolean success() {
        return this.success;
    }

    /**
     * 返回提示信息
     * @return 提示信息
     */
    @Override
    public String message() {
        return this.message;
    }
}
