package red.mulan.boot.common.handler;

import com.alibaba.fastjson2.JSON;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import red.mulan.boot.common.result.Result;

import java.io.IOException;

/**
 * 响应处理<br>
 *
 * @author Max
 * @version 1.0.0
 * @since 2023/2/18 14:52
 */
@Slf4j
public class ResponseHandler {


    /**
     * 响应JSON数据
     * @param response  response
     * @param result result
     * @throws IOException IOException
     */
    public void responseJson(HttpServletResponse response, @NotNull Result result) throws IOException {
        responseJson(HttpServletResponse.SC_OK,response,result);
    }

    /**
     *  响应JSON数据
     * @param status 响应状态码
     * @param response response
     * @param result 需要返回的数据
     * @throws IOException IOException
     */
    public void responseJson(int status,HttpServletResponse response, @NotNull Result result) throws IOException{
        if (null != result){
            response.setStatus(status);
            response.setCharacterEncoding("UTF-8");
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.getWriter().println(JSON.toJSONString(result));
            response.getWriter().flush();
            return;
        }
        log.warn("未响应JSON数据，返回的数据是空！！！");
    }
}
