package red.mulan.boot.common.exception;

import lombok.Getter;
import red.mulan.boot.common.result.Result;

/**
 * 自定义业务异常<br>
 *
 * @author Max
 * @version 1.0.0
 * @since 2023/2/17 20:54
 */
public class BizException extends RuntimeException{


    /**
     * 异常信息
     */
    @Getter
    private final transient Result result;

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public BizException(Result result) {
        super(result.message());
        this.result = result;
    }

    /**
     * 这个构造不推荐使用，如果对国际化没有要求的话可以使用,如果项目中涉及到国际化的话
     * 推荐 BizException(Result result) 这种构造方式
     * @param message 自定义错误信息
     */
    public BizException(String message){
        super(message);
        this.result = new Result() {
            @Override
            public String code() {
                return "500";
            }

            @Override
            public Boolean success() {
                return false;
            }

            @Override
            public String message() {
                return message;
            }
        };
    }
}
