package red.mulan.boot.common.utils;

import org.slf4j.MDC;

import java.util.UUID;

/**
 * TraceId工具类<br>
 *
 * @author Max
 * @version 1.0.0
 * @since 2023/2/17 20:48
 */
public class TraceIdUtils {
    /**
     * TraceId 常量
     */
    public static final String TRACE_ID = "TRACE_ID";
    /**
     *
     * 为当前线程设置一个TRACE_ID
     */
    public static void set() {
        MDC.put(TRACE_ID, generate());
    }

    /**
     * 返回当前线程的TRACE_ID
     * @return 当前线程的TRACE_ID
     */
    public static String get() {
        return MDC.get(TRACE_ID);
    }

    /**
     * 删除当前线程TRACE_ID
     */
    public static void remove() {
        MDC.remove(TRACE_ID);
    }

    /**
     * 生成一个TRACE_ID
     * @return TRACE_ID
     */
    public static String generate() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}
