/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.common.result;

import red.mulan.boot.common.code.CommonCode;
import red.mulan.boot.common.result.Result;
import red.mulan.boot.common.utils.TraceIdUtils;

public class ResponseResult<T>
implements Result {
    private final T data;
    private final String traceId;
    private final String code;
    private final boolean success;
    private final String message;

    public static <R> ResponseResult<R> ok() {
        return new ResponseResult(CommonCode.SUCCESS);
    }

    public static <R> ResponseResult<R> ok(R data) {
        return new ResponseResult<R>(CommonCode.SUCCESS, data);
    }

    public static <R> ResponseResult<R> fail() {
        return new ResponseResult(CommonCode.FAIL);
    }

    public static <R> ResponseResult<R> fail(Result result, R data) {
        return result.success() != false ? new ResponseResult<R>(CommonCode.FAIL, data) : new ResponseResult<R>(result, data);
    }

    public static <R> ResponseResult<R> fail(Result result) {
        return result.success() != false ? new ResponseResult(CommonCode.FAIL) : new ResponseResult(result);
    }

    public static <R> ResponseResult<R> unauthorized() {
        return new ResponseResult(CommonCode.UNAUTHORIZED);
    }

    public static <R> ResponseResult<R> forbidden() {
        return new ResponseResult(CommonCode.FORBIDDEN);
    }

    public ResponseResult(Result result, T data) {
        this.code = result.code();
        this.success = result.success();
        this.message = result.message();
        this.data = data;
        this.traceId = TraceIdUtils.get();
    }

    public ResponseResult(Result result) {
        this.code = result.code();
        this.success = result.success();
        this.message = result.message();
        this.data = null;
        this.traceId = TraceIdUtils.get();
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public Boolean success() {
        return this.success;
    }

    @Override
    public String message() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }
}

