/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.common.handler;

import jakarta.annotation.Resource;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class SpringBeanHandler {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanHandler.class);
    @Resource
    private ApplicationContext applicationContext;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void registerBean(String name, Class<?> clazz, Map<String, Object> args) {
        if (this.applicationContext.containsBean(name)) {
            return;
        }
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (!args.isEmpty()) {
            Set<Map.Entry<String, Object>> entries = args.entrySet();
            for (Map.Entry<String, Object> next : entries) {
                beanDefinitionBuilder.addPropertyValue(next.getKey(), next.getValue());
            }
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    public Object getBean(String beanName) {
        if (StringUtils.hasText((String)beanName)) {
            return this.applicationContext.getBean(beanName);
        }
        return null;
    }

    public void removeBean(String beanName) {
        this.lock.writeLock().lock();
        try {
            DefaultListableBeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory.containsBeanDefinition(beanName)) {
                beanFactory.destroySingleton(beanName);
                beanFactory.removeBeanDefinition(beanName);
                log.info("\u6ce8\u9500[{}]\u6210\u529f\uff01", (Object)beanName);
            } else {
                log.info("\u4e0d\u5b58\u5728[{}]\uff0c\u4e0d\u9700\u8981\u6ce8\u9500\uff01", (Object)beanName);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private DefaultListableBeanFactory getBeanFactory() {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
        return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
    }
}

