/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.pool;

import cn.hutool.core.text.CharSequenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import red.mulan.boot.common.handler.SpringBeanHandler;
import red.mulan.boot.pool.AbstractExecutorPool;

@ConfigurationProperties(prefix="mulan.pool.biz")
public class BizPool
extends AbstractExecutorPool {
    private static final Logger log = LoggerFactory.getLogger(BizPool.class);
    @Autowired
    private SpringBeanHandler springBeanHandler;
    private String beanName = "BIZ-POOL";
    private String threadNamePrefix = "MULAN-BIZ-";

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isEnable()) {
            this.springBeanHandler.registerBean(this.getBeanName(), ThreadPoolTaskExecutor.class, this.poolArgs());
            log.info("\u7ebf\u7a0b\u6c60\u6ce8\u518c\u6210\u529f,,beanName:{},threadNamePrefix:{}", (Object)this.getBeanName(), (Object)this.getThreadNamePrefix());
        } else {
            this.springBeanHandler.removeBean(CharSequenceUtil.lowerFirst((CharSequence)this.getClass().getSimpleName()));
            log.info("\u7ebf\u7a0b\u6c60\u672a\u5f00\u542f,beanName:{},threadNamePrefix:{}", (Object)this.getBeanName(), (Object)this.getThreadNamePrefix());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BizPool)) {
            return false;
        }
        BizPool other = (BizPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpringBeanHandler this$springBeanHandler = this.springBeanHandler;
        SpringBeanHandler other$springBeanHandler = other.springBeanHandler;
        if (this$springBeanHandler == null ? other$springBeanHandler != null : !this$springBeanHandler.equals(other$springBeanHandler)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        String this$threadNamePrefix = this.getThreadNamePrefix();
        String other$threadNamePrefix = other.getThreadNamePrefix();
        return !(this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BizPool;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SpringBeanHandler $springBeanHandler = this.springBeanHandler;
        result = result * 59 + ($springBeanHandler == null ? 43 : $springBeanHandler.hashCode());
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        String $threadNamePrefix = this.getThreadNamePrefix();
        result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
        return result;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }
}

