/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.pool;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import red.mulan.boot.common.handler.SpringBeanHandler;
import red.mulan.boot.pool.TraceIdTaskDecorator;

public abstract class AbstractExecutorPool
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractExecutorPool.class);
    private static final TraceIdTaskDecorator TRACE_ID_TASK_DECORATOR = new TraceIdTaskDecorator();
    @Autowired
    private SpringBeanHandler springBeanHandler;
    private int corePoolSize = 1;
    private int maxPoolSize = 20;
    private int keepAliveSeconds = 60;
    private int queueCapacity = 500;
    private boolean enable = false;
    private Class<? extends RejectedExecutionHandler> rejectedExecutionHandler;

    public abstract String getBeanName();

    public abstract String getThreadNamePrefix();

    public Map<String, Object> poolArgs() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        args.put("corePoolSize", this.corePoolSize);
        args.put("maxPoolSize", this.maxPoolSize);
        args.put("keepAliveSeconds", this.keepAliveSeconds);
        args.put("queueCapacity", this.queueCapacity);
        args.put("threadNamePrefix", this.getThreadNamePrefix());
        args.put("rejectedExecutionHandler", this.rejectedExecutionHandler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        args.put("taskDecorator", TRACE_ID_TASK_DECORATOR);
        return args;
    }

    public SpringBeanHandler getSpringBeanHandler() {
        return this.springBeanHandler;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Class<? extends RejectedExecutionHandler> getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public void setSpringBeanHandler(SpringBeanHandler springBeanHandler) {
        this.springBeanHandler = springBeanHandler;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRejectedExecutionHandler(Class<? extends RejectedExecutionHandler> rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExecutorPool)) {
            return false;
        }
        AbstractExecutorPool other = (AbstractExecutorPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getKeepAliveSeconds() != other.getKeepAliveSeconds()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        SpringBeanHandler this$springBeanHandler = this.getSpringBeanHandler();
        SpringBeanHandler other$springBeanHandler = other.getSpringBeanHandler();
        if (this$springBeanHandler == null ? other$springBeanHandler != null : !this$springBeanHandler.equals(other$springBeanHandler)) {
            return false;
        }
        Class<? extends RejectedExecutionHandler> this$rejectedExecutionHandler = this.getRejectedExecutionHandler();
        Class<? extends RejectedExecutionHandler> other$rejectedExecutionHandler = other.getRejectedExecutionHandler();
        return !(this$rejectedExecutionHandler == null ? other$rejectedExecutionHandler != null : !this$rejectedExecutionHandler.equals(other$rejectedExecutionHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractExecutorPool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaxPoolSize();
        result = result * 59 + this.getKeepAliveSeconds();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + (this.isEnable() ? 79 : 97);
        SpringBeanHandler $springBeanHandler = this.getSpringBeanHandler();
        result = result * 59 + ($springBeanHandler == null ? 43 : $springBeanHandler.hashCode());
        Class<? extends RejectedExecutionHandler> $rejectedExecutionHandler = this.getRejectedExecutionHandler();
        result = result * 59 + ($rejectedExecutionHandler == null ? 43 : $rejectedExecutionHandler.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractExecutorPool(springBeanHandler=" + this.getSpringBeanHandler() + ", corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", keepAliveSeconds=" + this.getKeepAliveSeconds() + ", queueCapacity=" + this.getQueueCapacity() + ", enable=" + this.isEnable() + ", rejectedExecutionHandler=" + this.getRejectedExecutionHandler() + ")";
    }
}

