/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.pool;

import cn.hutool.core.text.CharSequenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import red.mulan.boot.common.handler.SpringBeanHandler;
import red.mulan.boot.pool.AbstractExecutorPool;

@ConfigurationProperties(prefix="mulan.pool.task")
public class TaskPool
extends AbstractExecutorPool
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TaskPool.class);
    private String beanName = "TASK-POOL";
    private String threadNamePrefix = "MULAN-TASK-";
    @Autowired
    private SpringBeanHandler springBeanHandler;

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isEnable()) {
            this.springBeanHandler.registerBean(this.getBeanName(), ThreadPoolTaskExecutor.class, this.poolArgs());
            log.info("\u7ebf\u7a0b\u6c60\u6ce8\u518c\u6210\u529f,,beanName:{},threadNamePrefix:{}", (Object)this.getBeanName(), (Object)this.getThreadNamePrefix());
        } else {
            this.springBeanHandler.removeBean(CharSequenceUtil.lowerFirst((CharSequence)this.getClass().getSimpleName()));
            log.info("\u7ebf\u7a0b\u6c60\u672a\u5f00\u542f,beanName:{},threadNamePrefix:{}", (Object)this.getBeanName(), (Object)this.getThreadNamePrefix());
        }
    }

    @Override
    public SpringBeanHandler getSpringBeanHandler() {
        return this.springBeanHandler;
    }

    @Override
    public void setSpringBeanHandler(SpringBeanHandler springBeanHandler) {
        this.springBeanHandler = springBeanHandler;
    }

    @Override
    public String toString() {
        return "TaskPool(beanName=" + this.getBeanName() + ", threadNamePrefix=" + this.getThreadNamePrefix() + ", springBeanHandler=" + this.getSpringBeanHandler() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskPool)) {
            return false;
        }
        TaskPool other = (TaskPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        String this$threadNamePrefix = this.getThreadNamePrefix();
        String other$threadNamePrefix = other.getThreadNamePrefix();
        if (this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix)) {
            return false;
        }
        SpringBeanHandler this$springBeanHandler = this.getSpringBeanHandler();
        SpringBeanHandler other$springBeanHandler = other.getSpringBeanHandler();
        return !(this$springBeanHandler == null ? other$springBeanHandler != null : !this$springBeanHandler.equals(other$springBeanHandler));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TaskPool;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        String $threadNamePrefix = this.getThreadNamePrefix();
        result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
        SpringBeanHandler $springBeanHandler = this.getSpringBeanHandler();
        result = result * 59 + ($springBeanHandler == null ? 43 : $springBeanHandler.hashCode());
        return result;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }
}

