/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.redis;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisHandler {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean hasKey(String key) {
        return StringUtils.hasText((String)key) && null != this.redisTemplate.hasKey((Object)key);
    }

    public Long getKeyExpire(String key) {
        if (StringUtils.hasText((String)key)) {
            return this.redisTemplate.getExpire((Object)key);
        }
        return 0L;
    }

    public void expireKey(String key, long time) {
        this.expireKey(key, time, TimeUnit.SECONDS);
    }

    public void expireKey(String key, long time, TimeUnit timeUnit) {
        if (StringUtils.hasText((String)key)) {
            this.redisTemplate.expire((Object)key, time, timeUnit);
        }
    }

    public void renameKey(String oldKey, String newKey) {
        if (StringUtils.hasText((String)oldKey) && StringUtils.hasText((String)newKey)) {
            this.redisTemplate.rename((Object)oldKey, (Object)newKey);
        }
    }

    public void valueSet(String key, Object data) {
        if (StringUtils.hasText((String)key)) {
            this.redisTemplate.opsForValue().set((Object)key, data);
        }
    }

    public void valueSet(String key, Object value, long time) {
        this.valueSet(key, value, time, TimeUnit.SECONDS);
    }

    public void valueSet(String key, Object value, long time, TimeUnit timeUnit) {
        if (StringUtils.hasText((String)key)) {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.valueSet(key, value);
            }
        }
    }

    public Object valueGetAndSet(String key, Object value) {
        if (StringUtils.hasText((String)key)) {
            return this.redisTemplate.opsForValue().getAndSet((Object)key, value);
        }
        return null;
    }

    public void multiSet(Map<String, Object> valueMap) {
        if (!ObjectUtils.isEmpty(valueMap)) {
            this.redisTemplate.opsForValue().multiSet(valueMap);
        }
    }

    public Object valueGet(String key) {
        if (StringUtils.hasText((String)key)) {
            return this.redisTemplate.opsForValue().get((Object)key);
        }
        return null;
    }

    public List<Object> multiGet(Collection<String> keys) {
        if (!ObjectUtils.isEmpty(keys)) {
            return this.redisTemplate.opsForValue().multiGet(keys);
        }
        return Collections.emptyList();
    }

    public void hashSet(String key, String hashKey, Object value) {
        if (StringUtils.hasText((String)key) && StringUtils.hasText((String)hashKey)) {
            this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
        }
    }

    public Object hashGet(String key, String hashKey) {
        if (StringUtils.hasText((String)key) && StringUtils.hasText((String)hashKey)) {
            return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        }
        return null;
    }

    public void hashDel(String key, Object ... hashKey) {
        if (StringUtils.hasText((String)key) && !ObjectUtils.isEmpty((Object[])hashKey)) {
            this.redisTemplate.opsForHash().delete((Object)key, hashKey);
        }
    }
}

