/*
 * Decompiled with CFR 0.152.
 */
package red.mulan.boot.web.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@ConfigurationProperties(prefix="mulan.cors")
public class CorsConfig {
    private String allowedOriginPattern = "*";
    private Boolean allowCredentials = true;
    private String allowedMethod = "*";
    private String allowedHeader = "*";

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOriginPattern(this.allowedOriginPattern);
        configuration.setAllowCredentials(this.allowCredentials);
        configuration.addAllowedMethod("*");
        configuration.addAllowedHeader("*");
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.registerCorsConfiguration("/**", configuration);
        return new CorsFilter((CorsConfigurationSource)configurationSource);
    }

    public String getAllowedOriginPattern() {
        return this.allowedOriginPattern;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public String getAllowedMethod() {
        return this.allowedMethod;
    }

    public String getAllowedHeader() {
        return this.allowedHeader;
    }

    public void setAllowedOriginPattern(String allowedOriginPattern) {
        this.allowedOriginPattern = allowedOriginPattern;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setAllowedMethod(String allowedMethod) {
        this.allowedMethod = allowedMethod;
    }

    public void setAllowedHeader(String allowedHeader) {
        this.allowedHeader = allowedHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsConfig)) {
            return false;
        }
        CorsConfig other = (CorsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        String this$allowedOriginPattern = this.getAllowedOriginPattern();
        String other$allowedOriginPattern = other.getAllowedOriginPattern();
        if (this$allowedOriginPattern == null ? other$allowedOriginPattern != null : !this$allowedOriginPattern.equals(other$allowedOriginPattern)) {
            return false;
        }
        String this$allowedMethod = this.getAllowedMethod();
        String other$allowedMethod = other.getAllowedMethod();
        if (this$allowedMethod == null ? other$allowedMethod != null : !this$allowedMethod.equals(other$allowedMethod)) {
            return false;
        }
        String this$allowedHeader = this.getAllowedHeader();
        String other$allowedHeader = other.getAllowedHeader();
        return !(this$allowedHeader == null ? other$allowedHeader != null : !this$allowedHeader.equals(other$allowedHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CorsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        String $allowedOriginPattern = this.getAllowedOriginPattern();
        result = result * 59 + ($allowedOriginPattern == null ? 43 : $allowedOriginPattern.hashCode());
        String $allowedMethod = this.getAllowedMethod();
        result = result * 59 + ($allowedMethod == null ? 43 : $allowedMethod.hashCode());
        String $allowedHeader = this.getAllowedHeader();
        result = result * 59 + ($allowedHeader == null ? 43 : $allowedHeader.hashCode());
        return result;
    }

    public String toString() {
        return "CorsConfig(allowedOriginPattern=" + this.getAllowedOriginPattern() + ", allowCredentials=" + this.getAllowCredentials() + ", allowedMethod=" + this.getAllowedMethod() + ", allowedHeader=" + this.getAllowedHeader() + ")";
    }
}

