/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.schemaspy.util.LineWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DOMUtil {
    public static void printDOM(Node node, LineWriter out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean indentSpecified = false;
        try {
            factory.setAttribute("indent-number", new Integer(3));
            indentSpecified = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer xformer = factory.newTransformer();
        xformer.setOutputProperty("indent", "yes");
        if (!indentSpecified) {
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        }
        xformer.transform(new DOMSource(node), new StreamResult(out));
    }

    public static void appendAttribute(Node node, String name, String value) {
        Attr attribute = node.getOwnerDocument().createAttribute(name);
        attribute.setNodeValue(value);
        node.getAttributes().setNamedItem(attribute);
    }
}

