/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private final List<Integer> segments = new ArrayList<Integer>();
    private final String asString;
    private final int hashCode;

    public Version(String version) {
        this.asString = version;
        int hash = 0;
        if (version != null) {
            StringTokenizer tokenizer = new StringTokenizer(version, ". -_");
            while (tokenizer.hasMoreTokens()) {
                Integer segment = new Integer(tokenizer.nextToken());
                this.segments.add(segment);
                hash += segment.intValue();
            }
        }
        this.hashCode = hash;
    }

    @Override
    public int compareTo(Version other) {
        int size = Math.min(this.segments.size(), other.segments.size());
        for (int i = 0; i < size; ++i) {
            Integer otherSegment;
            Integer thisSegment = this.segments.get(i);
            int result = thisSegment.compareTo(otherSegment = other.segments.get(i));
            if (result == 0) continue;
            return result;
        }
        if (this.segments.size() == other.segments.size()) {
            return 0;
        }
        if (this.segments.size() > other.segments.size()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.asString;
    }
}

