/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.view.SqlFormatter;

public class DefaultSqlFormatter
implements SqlFormatter {
    private Set<String> keywords;
    private Map<String, Table> tablesByPossibleNames;
    private static String TOKENS = " \t\n\r\f()<>|,";

    @Override
    public String format(String sql, Database db, Set<Table> references) {
        boolean alreadyFormatted;
        StringBuilder formatted = new StringBuilder(sql.length() * 2);
        boolean bl = alreadyFormatted = sql.contains("\n") || sql.contains("\r");
        if (alreadyFormatted) {
            formatted.append("<div class='viewDefinition preFormatted'>");
            int len = sql.length();
            for (int i = 0; i < len; ++i) {
                char ch = sql.charAt(i);
                if (Character.isWhitespace(ch)) {
                    formatted.append(ch);
                    continue;
                }
                formatted.append(HtmlEncoder.encodeToken(ch));
            }
        } else {
            formatted.append("  <div class='viewDefinition'>");
            Set<String> keywords = this.getKeywords(db.getMetaData());
            StringTokenizer tokenizer = new StringTokenizer(sql, TOKENS, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (keywords.contains(token.toUpperCase())) {
                    formatted.append("<b>");
                    formatted.append(token);
                    formatted.append("</b>");
                    continue;
                }
                formatted.append(HtmlEncoder.encodeToken(token));
            }
        }
        formatted.append("</div>");
        references.addAll(this.getReferencedTables(sql, db));
        return formatted.toString();
    }

    protected Set<Table> getReferencedTables(String sql, Database db) {
        HashSet<Table> referenced = new HashSet<Table>();
        Map<String, Table> tables = this.getTableMap(db);
        Set<String> keywords = this.getKeywords(db.getMetaData());
        StringTokenizer tokenizer = new StringTokenizer(sql, TOKENS, true);
        while (tokenizer.hasMoreTokens()) {
            int lastDot;
            String token = tokenizer.nextToken();
            if (keywords.contains(token.toUpperCase())) continue;
            Table t = tables.get(token);
            if (t == null && (lastDot = token.lastIndexOf(46)) != -1) {
                t = tables.get(token.substring(0, lastDot));
            }
            if (t == null) continue;
            referenced.add(t);
        }
        return referenced;
    }

    protected Map<String, Table> getTableMap(Database db) {
        if (this.tablesByPossibleNames == null) {
            this.tablesByPossibleNames = new CaseInsensitiveMap<Table>();
            this.tablesByPossibleNames.putAll(this.getTableMap(db.getTables(), db.getName()));
            this.tablesByPossibleNames.putAll(this.getTableMap(db.getViews(), db.getName()));
        }
        return this.tablesByPossibleNames;
    }

    protected Map<String, Table> getTableMap(Collection<? extends Table> tables, String dbName) {
        CaseInsensitiveMap<Table> map = new CaseInsensitiveMap<Table>();
        for (Table table : tables) {
            String name = table.getName();
            String schema = table.getSchema();
            if (schema == null) {
                schema = dbName;
            }
            map.put(name, table);
            map.put("`" + name + "`", table);
            map.put("'" + name + "'", table);
            map.put("\"" + name + "\"", table);
            map.put(schema + "." + name, table);
            map.put("`" + schema + "`.`" + name + "`", table);
            map.put("'" + schema + "'.'" + name + "'", table);
            map.put("\"" + schema + "\".\"" + name + "\"", table);
            map.put("`" + schema + '.' + name + "`", table);
            map.put("'" + schema + '.' + name + "'", table);
            map.put("\"" + schema + '.' + name + "\"", table);
        }
        return map;
    }

    public Set<String> getKeywords(DatabaseMetaData meta) {
        if (this.keywords == null) {
            this.keywords = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END - EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"));
            try {
                String[] keywordsArray = new String[]{meta.getSQLKeywords(), meta.getSystemFunctions(), meta.getNumericFunctions(), meta.getStringFunctions(), meta.getTimeDateFunctions()};
                for (int i = 0; i < keywordsArray.length; ++i) {
                    StringTokenizer tokenizer = new StringTokenizer(keywordsArray[i].toUpperCase(), ",");
                    while (tokenizer.hasMoreTokens()) {
                        this.keywords.add(tokenizer.nextToken().trim());
                    }
                }
            }
            catch (Exception exc) {
                System.err.println(exc);
            }
        }
        return this.keywords;
    }
}

