/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlDiagramFormatter;

public class HtmlOrphansPage
extends HtmlDiagramFormatter {
    private static HtmlOrphansPage instance = new HtmlOrphansPage();

    private HtmlOrphansPage() {
    }

    public static HtmlOrphansPage getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Database db, List<Table> orphanTables, File diagramDir, LineWriter html) throws IOException {
        Dot dot = this.getDot();
        if (dot == null) {
            return false;
        }
        HashSet<Table> orphansWithImpliedRelationships = new HashSet<Table>();
        for (Table table : orphanTables) {
            if (table.isOrphan(true)) continue;
            orphansWithImpliedRelationships.add(table);
        }
        this.writeHeader(db, "Utility Tables", !orphansWithImpliedRelationships.isEmpty(), html);
        html.writeln("<a name='diagram'>");
        try {
            StringBuilder maps = new StringBuilder(65536);
            for (Table table : orphanTables) {
                String dotBaseFilespec = table.getName();
                File dotFile = new File(diagramDir, dotBaseFilespec + ".1degree.dot");
                File imgFile = new File(diagramDir, dotBaseFilespec + ".1degree.png");
                LineWriter dotOut = new LineWriter(dotFile, "UTF-8");
                DotFormatter.getInstance().writeOrphan(table, dotOut);
                dotOut.close();
                try {
                    maps.append(dot.generateDiagram(dotFile, imgFile));
                }
                catch (Dot.DotFailure dotFailure) {
                    System.err.println(dotFailure);
                    boolean bl = false;
                    html.writeln("</a>");
                    this.writeFooter(html);
                    return bl;
                }
                html.write("  <img src='diagrams/summary/" + imgFile.getName() + "' usemap='#" + table + "' border='0' alt='' align='top'");
                if (orphansWithImpliedRelationships.contains(table)) {
                    html.write(" class='impliedNotOrphan'");
                }
                html.writeln(">");
            }
            html.write(maps.toString());
            boolean bl = true;
            return bl;
        }
        finally {
            html.writeln("</a>");
            this.writeFooter(html);
        }
    }

    private void writeHeader(Database db, String title, boolean hasImpliedRelationships, LineWriter html) throws IOException {
        this.writeHeader(db, null, title, true, html);
        html.writeln("<table class='container' width='100%'>");
        html.writeln("<tr><td class='container'>");
        this.writeGeneratedBy(db.getConnectTime(), html);
        html.writeln("</td>");
        html.writeln("<td class='container' align='right' valign='top' rowspan='2'>");
        this.writeLegend(false, html);
        html.writeln("</td></tr>");
        html.writeln("<tr><td class='container' align='left' valign='top'>");
        if (hasImpliedRelationships) {
            html.writeln("<form action=''>");
            html.writeln(" <label for='removeImpliedOrphans'><input type=checkbox id='removeImpliedOrphans'>");
            html.writeln("  Hide tables with implied relationships</label>");
            html.writeln("</form>");
        }
        html.writeln("</td></tr></table>");
    }

    @Override
    protected boolean isOrphansPage() {
        return true;
    }
}

