/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.util.LineWriter;

public class StyleSheet {
    private static StyleSheet instance;
    private final String css;
    private String bodyBackgroundColor;
    private String tableHeadBackgroundColor;
    private String tableBackgroundColor;
    private String linkColor;
    private String linkVisitedColor;
    private String primaryKeyBackgroundColor;
    private String indexedColumnBackgroundColor;
    private String selectedTableBackgroundColor;
    private String excludedColumnBackgroundColor;
    private final List<String> ids = new ArrayList<String>();

    private StyleSheet(BufferedReader cssReader) throws IOException {
        String line;
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder data = new StringBuilder();
        while ((line = cssReader.readLine()) != null) {
            data.append(line);
            data.append(lineSeparator);
        }
        this.css = data.toString();
        int startComment = data.indexOf("/*");
        while (startComment != -1) {
            int endComment = data.indexOf("*/");
            data.replace(startComment, endComment + 2, "");
            startComment = data.indexOf("/*");
        }
        StringTokenizer tokenizer = new StringTokenizer(data.toString(), "{}");
        String id = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (id == null) {
                id = token.toLowerCase();
                this.ids.add(id);
                continue;
            }
            Map<String, String> attribs = this.parseAttributes(token);
            if (id.equals(".content")) {
                this.bodyBackgroundColor = attribs.get("background");
            } else if (id.equals("th")) {
                this.tableHeadBackgroundColor = attribs.get("background-color");
            } else if (id.equals("td")) {
                this.tableBackgroundColor = attribs.get("background-color");
            } else if (id.equals(".primarykey")) {
                this.primaryKeyBackgroundColor = attribs.get("background");
            } else if (id.equals(".indexedcolumn")) {
                this.indexedColumnBackgroundColor = attribs.get("background");
            } else if (id.equals(".selectedtable")) {
                this.selectedTableBackgroundColor = attribs.get("background");
            } else if (id.equals(".excludedcolumn")) {
                this.excludedColumnBackgroundColor = attribs.get("background");
            } else if (id.equals("a:link")) {
                this.linkColor = attribs.get("color");
            } else if (id.equals("a:visited")) {
                this.linkVisitedColor = attribs.get("color");
            }
            id = null;
        }
    }

    public static StyleSheet getInstance() throws ParseException {
        if (instance == null) {
            try {
                instance = new StyleSheet(new BufferedReader(StyleSheet.getReader(Config.getInstance().getCss())));
            }
            catch (IOException exc) {
                throw new ParseException(exc);
            }
        }
        return instance;
    }

    private static Reader getReader(String cssName) throws IOException {
        File cssFile = new File(cssName);
        if (cssFile.exists()) {
            return new FileReader(cssFile);
        }
        cssFile = new File(System.getProperty("user.dir"), cssName);
        if (cssFile.exists()) {
            return new FileReader(cssFile);
        }
        InputStream cssStream = StyleSheet.class.getClassLoader().getResourceAsStream(cssName);
        if (cssStream == null) {
            throw new ParseException("Unable to find requested style sheet: " + cssName);
        }
        return new InputStreamReader(cssStream);
    }

    private Map<String, String> parseAttributes(String data) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        try {
            StringTokenizer attrTokenizer = new StringTokenizer(data, ";");
            while (attrTokenizer.hasMoreTokens()) {
                StringTokenizer pairTokenizer = new StringTokenizer(attrTokenizer.nextToken(), ":");
                String attribute = pairTokenizer.nextToken().trim().toLowerCase();
                String value = pairTokenizer.nextToken().trim().toLowerCase();
                attribs.put(attribute, value);
            }
        }
        catch (NoSuchElementException badToken) {
            System.err.println("Failed to extract attributes from '" + data + "'");
            throw badToken;
        }
        return attribs;
    }

    public void write(LineWriter out) throws IOException {
        out.write(this.css);
    }

    public String getBodyBackground() {
        if (this.bodyBackgroundColor == null) {
            throw new MissingCssPropertyException(".content", "background");
        }
        return this.bodyBackgroundColor;
    }

    public String getTableBackground() {
        if (this.tableBackgroundColor == null) {
            throw new MissingCssPropertyException("td", "background-color");
        }
        return this.tableBackgroundColor;
    }

    public String getTableHeadBackground() {
        if (this.tableHeadBackgroundColor == null) {
            throw new MissingCssPropertyException("th", "background-color");
        }
        return this.tableHeadBackgroundColor;
    }

    public String getPrimaryKeyBackground() {
        if (this.primaryKeyBackgroundColor == null) {
            throw new MissingCssPropertyException(".primaryKey", "background");
        }
        return this.primaryKeyBackgroundColor;
    }

    public String getIndexedColumnBackground() {
        if (this.indexedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".indexedColumn", "background");
        }
        return this.indexedColumnBackgroundColor;
    }

    public String getSelectedTableBackground() {
        if (this.selectedTableBackgroundColor == null) {
            throw new MissingCssPropertyException(".selectedTable", "background");
        }
        return this.selectedTableBackgroundColor;
    }

    public String getExcludedColumnBackgroundColor() {
        if (this.excludedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".excludedColumn", "background");
        }
        return this.excludedColumnBackgroundColor;
    }

    public String getLinkColor() {
        if (this.linkColor == null) {
            throw new MissingCssPropertyException("a:link", "color");
        }
        return this.linkColor;
    }

    public String getLinkVisitedColor() {
        if (this.linkVisitedColor == null) {
            throw new MissingCssPropertyException("a:visited", "color");
        }
        return this.linkVisitedColor;
    }

    public static class ParseException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 1L;

        public ParseException(Exception cause) {
            super(cause);
        }

        public ParseException(String msg) {
            super(msg);
        }
    }

    public static class MissingCssPropertyException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 1L;

        public MissingCssPropertyException(String cssSection, String propName) {
            super("Required property '" + propName + "' was not found for the definition of '" + cssSection + "' in " + Config.getInstance().getCss());
        }
    }
}

