/*
 * Decompiled with CFR 0.152.
 */
package red.sukun1899;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import red.sukun1899.ParameterType;
import red.sukun1899.SchemaSpyConfig;

class SchemaSpyConfigMap {
    private Map<ParameterType, String> configMap = new LinkedHashMap<ParameterType, String>();

    SchemaSpyConfigMap(SchemaSpyConfig config) {
        config.getConfigrations().forEach(this::put);
    }

    public String put(ParameterType key, String value) {
        String pushValue = value;
        switch (key) {
            case OUTPUT_DIRECTORY: {
                pushValue = value == null ? "target" : value;
                pushValue = pushValue + "/schemaspy";
                break;
            }
        }
        if (this.validateRequiredValue(key, pushValue)) {
            throw new IllegalArgumentException((Object)((Object)key) + " is required. But value is empty.");
        }
        if (pushValue == null) {
            return null;
        }
        return this.configMap.put(key, pushValue);
    }

    public String get(ParameterType key) {
        return this.configMap.get((Object)key);
    }

    List<String> toArgumentStrings() {
        ArrayList<String> argumentStrings = new ArrayList<String>();
        this.configMap.forEach((key, value) -> {
            argumentStrings.add(key.getParameter());
            if (value != null && !value.isEmpty()) {
                argumentStrings.add((String)value);
            }
        });
        return argumentStrings;
    }

    private boolean validateRequiredValue(ParameterType key, String value) {
        return key.isRequired() && (value == null || value.isEmpty());
    }

    public Map<ParameterType, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<ParameterType, String> configMap) {
        this.configMap = configMap;
    }
}

