/*
 * Decompiled with CFR 0.152.
 */
package red.sukun1899;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import red.sukun1899.ParameterType;
import red.sukun1899.SchemaSpy;
import red.sukun1899.SchemaSpyConfig;
import red.sukun1899.SchemaSpyConfigMap;

@Mojo(name="schemaspy", defaultPhase=LifecyclePhase.SITE)
class SchemaSpyMojo
extends AbstractMojo
implements SchemaSpyConfig {
    @Parameter(defaultValue="mysql", property="databaseType", required=true)
    private String databaseType;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="localhost", property="host", required=true)
    private String host;
    @Parameter(defaultValue="sample", property="dbName", required=true)
    private String dbName;
    @Parameter(defaultValue="root", property="user", required=true)
    private String user;
    @Parameter(property="password")
    private String password;
    @Parameter(defaultValue="utf-8", property="charset", required=true)
    private String charset;

    SchemaSpyMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"schemaspy-maven-plugin start!");
        SchemaSpy schemaSpy = new SchemaSpy(new SchemaSpyConfigMap(this));
        try {
            schemaSpy.execute();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed schemaSpy execute", (Throwable)e);
        }
        this.getLog().info((CharSequence)"schemaspy-maven-plugin end!");
    }

    @Override
    public Map<ParameterType, String> getConfigrations() {
        LinkedHashMap<ParameterType, String> configrations = new LinkedHashMap<ParameterType, String>();
        configrations.put(ParameterType.DATABASE_TYPE, this.getDatabaseType());
        configrations.put(ParameterType.HOST, this.getHost());
        configrations.put(ParameterType.DB_NAME, this.getDbName());
        configrations.put(ParameterType.USER, this.getUser());
        configrations.put(ParameterType.PASSWORD, this.getPassword());
        configrations.put(ParameterType.CHARSET, this.getCharset());
        configrations.put(ParameterType.OUTPUT_DIRECTORY, this.getOutputDirectory());
        return configrations;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getHost() {
        return this.host;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCharset() {
        return this.charset;
    }
}

