/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.MultipleSchemaAnalyzer;
import net.sourceforge.schemaspy.TableOrderer;
import net.sourceforge.schemaspy.model.ConnectionFailure;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.EmptySchemaException;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.util.ConnectionURLBuilder;
import net.sourceforge.schemaspy.util.DOMUtil;
import net.sourceforge.schemaspy.util.DbSpecificOption;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.util.LogFormatter;
import net.sourceforge.schemaspy.util.PasswordReader;
import net.sourceforge.schemaspy.util.ResourceWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlAnomaliesPage;
import net.sourceforge.schemaspy.view.HtmlColumnsPage;
import net.sourceforge.schemaspy.view.HtmlConstraintsPage;
import net.sourceforge.schemaspy.view.HtmlMainIndexPage;
import net.sourceforge.schemaspy.view.HtmlOrphansPage;
import net.sourceforge.schemaspy.view.HtmlRelationshipsPage;
import net.sourceforge.schemaspy.view.HtmlTablePage;
import net.sourceforge.schemaspy.view.ImageWriter;
import net.sourceforge.schemaspy.view.StyleSheet;
import net.sourceforge.schemaspy.view.TextFormatter;
import net.sourceforge.schemaspy.view.WriteStats;
import net.sourceforge.schemaspy.view.XmlTableFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaAnalyzer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean fineEnabled;

    public Database analyze(Config config) throws Exception {
        try {
            LineWriter out;
            SchemaMeta schemaMeta;
            long start;
            if (config.isHelpRequired()) {
                config.dumpUsage(null, false);
                return null;
            }
            if (config.isDbHelpRequired()) {
                config.dumpUsage(null, true);
                return null;
            }
            Logger.getLogger("").setLevel(config.getLogLevel());
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                ((ConsoleHandler)handler).setFormatter(new LogFormatter());
                handler.setLevel(config.getLogLevel());
            }
            this.fineEnabled = this.logger.isLoggable(Level.FINE);
            this.logger.info("Starting schema analysis");
            long startDiagrammingDetails = start = System.currentTimeMillis();
            long startSummarizing = start;
            File outputDir = config.getOutputDir();
            if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
                throw new IOException("Failed to create directory '" + outputDir + "'");
            }
            List<String> schemas = config.getSchemas();
            if (schemas != null) {
                List<String> args = config.asList();
                SchemaAnalyzer.yankParam(args, "-o");
                SchemaAnalyzer.yankParam(args, "-s");
                args.remove("-all");
                args.remove("-schemas");
                args.remove("-schemata");
                String dbName = config.getDb();
                MultipleSchemaAnalyzer.getInstance().analyze(dbName, schemas, args, config.getUser(), outputDir, config.getCharset(), Config.getLoadedFromJar());
                return null;
            }
            Properties properties = config.getDbProperties(config.getDbType());
            ConnectionURLBuilder urlBuilder = new ConnectionURLBuilder(config, properties);
            if (config.getDb() == null) {
                config.setDb(urlBuilder.getConnectionURL());
            }
            if (config.getRemainingParameters().size() != 0) {
                StringBuilder msg = new StringBuilder("Unrecognized option(s):");
                for (String remnant : config.getRemainingParameters()) {
                    msg.append(" " + remnant);
                }
                this.logger.warning(msg.toString());
            }
            String driverClass = properties.getProperty("driver");
            String driverPath = properties.getProperty("driverPath");
            if (driverPath == null) {
                driverPath = "";
            }
            if (config.getDriverPath() != null) {
                driverPath = config.getDriverPath() + File.pathSeparator + driverPath;
            }
            Connection connection = this.getConnection(config, urlBuilder.getConnectionURL(), driverClass, driverPath);
            DatabaseMetaData meta = connection.getMetaData();
            String dbName = config.getDb();
            String schema = config.getSchema();
            if (config.isEvaluateAllEnabled()) {
                List<String> args = config.asList();
                for (DbSpecificOption option : urlBuilder.getOptions()) {
                    if (args.contains("-" + option.getName())) continue;
                    args.add("-" + option.getName());
                    args.add(option.getValue().toString());
                }
                SchemaAnalyzer.yankParam(args, "-o");
                SchemaAnalyzer.yankParam(args, "-s");
                args.remove("-all");
                String schemaSpec = config.getSchemaSpec();
                if (schemaSpec == null) {
                    schemaSpec = properties.getProperty("schemaSpec", ".*");
                }
                MultipleSchemaAnalyzer.getInstance().analyze(dbName, meta, schemaSpec, null, args, config.getUser(), outputDir, config.getCharset(), Config.getLoadedFromJar());
                return null;
            }
            if (schema == null && meta.supportsSchemasInTableDefinitions() && !config.isSchemaDisabled()) {
                schema = config.getUser();
                if (schema == null) {
                    throw new InvalidConfigurationException("Either a schema ('-s') or a user ('-u') must be specified");
                }
                config.setSchema(schema);
            }
            SchemaMeta schemaMeta2 = schemaMeta = config.getMeta() == null ? null : new SchemaMeta(config.getMeta(), dbName, schema);
            if (config.isHtmlGenerationEnabled()) {
                new File(outputDir, "tables").mkdirs();
                new File(outputDir, "diagrams/summary").mkdirs();
                this.logger.info("Connected to " + meta.getDatabaseProductName() + " - " + meta.getDatabaseProductVersion());
                if (schemaMeta != null && schemaMeta.getFile() != null) {
                    this.logger.info("Using additional metadata from " + schemaMeta.getFile());
                }
                this.logger.info("Gathering schema details");
                if (!this.fineEnabled) {
                    System.out.print("Gathering schema details...");
                }
            }
            Database db = new Database(config, connection, meta, dbName, schema, properties, schemaMeta);
            schemaMeta = null;
            ArrayList<Table> tables = new ArrayList<Table>(db.getTables());
            tables.addAll(db.getViews());
            if (tables.isEmpty()) {
                SchemaAnalyzer.dumpNoTablesMessage(schema, config.getUser(), meta, config.getTableInclusions() != null);
                if (!config.isOneOfMultipleSchemas()) {
                    throw new EmptySchemaException();
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement("database");
            document.appendChild(rootNode);
            DOMUtil.appendAttribute(rootNode, "name", dbName);
            if (schema != null) {
                DOMUtil.appendAttribute(rootNode, "schema", schema);
            }
            DOMUtil.appendAttribute(rootNode, "type", db.getDatabaseProduct());
            if (config.isHtmlGenerationEnabled()) {
                boolean hasOrphans;
                startSummarizing = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (startSummarizing - start) / 1000L + "sec)");
                }
                this.logger.info("Gathered schema details in " + (startSummarizing - start) / 1000L + " seconds");
                this.logger.info("Writing/graphing summary");
                System.err.flush();
                System.out.flush();
                if (!this.fineEnabled) {
                    System.out.print("Writing/graphing summary");
                    System.out.print(".");
                }
                ImageWriter.getInstance().writeImages(outputDir);
                ResourceWriter.getInstance().writeResource("/js/jquery.js", new File(outputDir, "/jquery.js"));
                ResourceWriter.getInstance().writeResource("/js/schemaSpy.js", new File(outputDir, "/schemaSpy.js"));
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                boolean showDetailedTables = tables.size() <= config.getMaxDetailedTables();
                boolean includeImpliedConstraints = config.isImpliedConstraintsEnabled();
                if (config.isRailsEnabled()) {
                    DbAnalyzer.getRailsConstraints(db.getTablesByName());
                }
                File diagramsDir = new File(outputDir, "diagrams/summary");
                String dotBaseFilespec = "relationships";
                out = new LineWriter(new File(diagramsDir, dotBaseFilespec + ".real.compact.dot"), "UTF-8");
                WriteStats stats = new WriteStats(tables);
                DotFormatter.getInstance().writeRealRelationships(db, tables, true, showDetailedTables, stats, out);
                boolean hasRealRelationships = stats.getNumTablesWritten() > 0 || stats.getNumViewsWritten() > 0;
                out.close();
                if (hasRealRelationships) {
                    if (!this.fineEnabled) {
                        System.out.print(".");
                    }
                    out = new LineWriter(new File(diagramsDir, dotBaseFilespec + ".real.large.dot"), "UTF-8");
                    DotFormatter.getInstance().writeRealRelationships(db, tables, false, showDetailedTables, stats, out);
                    out.close();
                }
                List<ImpliedForeignKeyConstraint> impliedConstraints = null;
                impliedConstraints = includeImpliedConstraints ? DbAnalyzer.getImpliedConstraints(tables) : new ArrayList<ImpliedForeignKeyConstraint>();
                List<Table> orphans = DbAnalyzer.getOrphans(tables);
                boolean bl = hasOrphans = !orphans.isEmpty() && Dot.getInstance().isValid();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                File impliedDotFile = new File(diagramsDir, dotBaseFilespec + ".implied.compact.dot");
                out = new LineWriter(impliedDotFile, "UTF-8");
                boolean hasImplied = DotFormatter.getInstance().writeAllRelationships(db, tables, true, showDetailedTables, stats, out);
                Set<TableColumn> excludedColumns = stats.getExcludedColumns();
                out.close();
                if (hasImplied) {
                    impliedDotFile = new File(diagramsDir, dotBaseFilespec + ".implied.large.dot");
                    out = new LineWriter(impliedDotFile, "UTF-8");
                    DotFormatter.getInstance().writeAllRelationships(db, tables, false, showDetailedTables, stats, out);
                    out.close();
                } else {
                    impliedDotFile.delete();
                }
                out = new LineWriter(new File(outputDir, dotBaseFilespec + ".html"), config.getCharset());
                HtmlRelationshipsPage.getInstance().write(db, diagramsDir, dotBaseFilespec, hasOrphans, hasRealRelationships, hasImplied, excludedColumns, out);
                out.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                dotBaseFilespec = "utilities";
                out = new LineWriter(new File(outputDir, dotBaseFilespec + ".html"), config.getCharset());
                HtmlOrphansPage.getInstance().write(db, orphans, diagramsDir, out);
                out.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                out = new LineWriter(new File(outputDir, "index.html"), 65536, config.getCharset());
                HtmlMainIndexPage.getInstance().write(db, tables, hasOrphans, out);
                out.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                List<ForeignKeyConstraint> constraints = DbAnalyzer.getForeignKeyConstraints(tables);
                out = new LineWriter(new File(outputDir, "constraints.html"), 262144, config.getCharset());
                HtmlConstraintsPage constraintIndexFormatter = HtmlConstraintsPage.getInstance();
                constraintIndexFormatter.write(db, constraints, tables, hasOrphans, out);
                out.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                out = new LineWriter(new File(outputDir, "anomalies.html"), 16384, config.getCharset());
                HtmlAnomaliesPage.getInstance().write(db, tables, impliedConstraints, hasOrphans, out);
                out.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                for (HtmlColumnsPage.ColumnInfo columnInfo : HtmlColumnsPage.getInstance().getColumnInfos()) {
                    out = new LineWriter(new File(outputDir, columnInfo.getLocation()), 16384, config.getCharset());
                    HtmlColumnsPage.getInstance().write(db, tables, columnInfo, hasOrphans, out);
                    out.close();
                }
                startDiagrammingDetails = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (startDiagrammingDetails - startSummarizing) / 1000L + "sec)");
                }
                this.logger.info("Completed summary in " + (startDiagrammingDetails - startSummarizing) / 1000L + " seconds");
                this.logger.info("Writing/diagramming details");
                if (!this.fineEnabled) {
                    System.out.print("Writing/diagramming details");
                }
                HtmlTablePage tableFormatter = HtmlTablePage.getInstance();
                for (Table table : tables) {
                    if (!this.fineEnabled) {
                        System.out.print('.');
                    } else {
                        this.logger.fine("Writing details of " + table.getName());
                    }
                    out = new LineWriter(new File(outputDir, "tables/" + table.getName() + ".html"), 24576, config.getCharset());
                    tableFormatter.write(db, table, hasOrphans, outputDir, stats, out);
                    out.close();
                }
                out = new LineWriter(new File(outputDir, "schemaSpy.css"), config.getCharset());
                StyleSheet.getInstance().write(out);
                out.close();
            }
            XmlTableFormatter.getInstance().appendTables(rootNode, tables);
            String xmlName = dbName;
            xmlName = new File(xmlName).getName();
            if (schema != null) {
                xmlName = xmlName + '.' + schema;
            }
            out = new LineWriter(new File(outputDir, xmlName + ".xml"), "UTF-8");
            document.getDocumentElement().normalize();
            DOMUtil.printDOM(document, out);
            out.close();
            builder = null;
            connection.close();
            connection = null;
            document = null;
            factory = null;
            meta = null;
            properties = null;
            rootNode = null;
            urlBuilder = null;
            ArrayList<ForeignKeyConstraint> recursiveConstraints = new ArrayList<ForeignKeyConstraint>();
            TableOrderer orderer = new TableOrderer();
            List<Table> orderedTables = orderer.getTablesOrderedByRI(db.getTables(), recursiveConstraints);
            out = new LineWriter(new File(outputDir, "insertionOrder.txt"), 16384, "UTF-8");
            TextFormatter.getInstance().write(orderedTables, false, out);
            out.close();
            out = new LineWriter(new File(outputDir, "deletionOrder.txt"), 16384, "UTF-8");
            Collections.reverse(orderedTables);
            TextFormatter.getInstance().write(orderedTables, false, out);
            out.close();
            if (config.isHtmlGenerationEnabled()) {
                long end = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (end - startDiagrammingDetails) / 1000L + "sec)");
                }
                this.logger.info("Wrote table details in " + (end - startDiagrammingDetails) / 1000L + " seconds");
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("Wrote relationship details of " + tables.size() + " tables/views to directory '" + config.getOutputDir() + "' in " + (end - start) / 1000L + " seconds.");
                    this.logger.info("View the results by opening " + new File(config.getOutputDir(), "index.html"));
                } else {
                    System.out.println("Wrote relationship details of " + tables.size() + " tables/views to directory '" + config.getOutputDir() + "' in " + (end - start) / 1000L + " seconds.");
                    System.out.println("View the results by opening " + new File(config.getOutputDir(), "index.html"));
                }
            }
            return db;
        }
        catch (Config.MissingRequiredParameterException missingParam) {
            config.dumpUsage(missingParam.getMessage(), missingParam.isDbTypeSpecific());
            return null;
        }
    }

    private static void dumpNoTablesMessage(String schema, String user, DatabaseMetaData meta, boolean specifiedInclusions) throws SQLException {
        System.out.println();
        System.out.println();
        System.out.println("No tables or views were found in schema '" + schema + "'.");
        List<String> schemas = DbAnalyzer.getSchemas(meta);
        if (schema == null || schemas.contains(schema)) {
            System.out.println("The schema exists in the database, but the user you specified (" + user + ')');
            System.out.println("  might not have rights to read its contents.");
            if (specifiedInclusions) {
                System.out.println("Another possibility is that the regular expression that you specified");
                System.out.println("  for what to include (via -i) didn't match any tables.");
            }
        } else {
            System.out.println("The schema does not exist in the database.");
            System.out.println("Make sure that you specify a valid schema with the -s option and that");
            System.out.println("  the user specified (" + user + ") can read from the schema.");
            System.out.println("Note that schema names are usually case sensitive.");
        }
        System.out.println();
        boolean plural = schemas.size() != 1;
        System.out.println(schemas.size() + " schema" + (plural ? "s" : "") + " exist" + (plural ? "" : "s") + " in this database.");
        System.out.println("Some of these \"schemas\" may be users or system schemas.");
        System.out.println();
        for (String unknown : schemas) {
            System.out.print(unknown + " ");
        }
        System.out.println();
        List<String> populatedSchemas = DbAnalyzer.getPopulatedSchemas(meta);
        if (populatedSchemas.isEmpty()) {
            System.out.println("Unable to determine if any of the schemas contain tables/views");
        } else {
            System.out.println("These schemas contain tables/views that user '" + user + "' can see:");
            System.out.println();
            for (String populated : populatedSchemas) {
                System.out.print(" " + populated);
            }
        }
    }

    private Connection getConnection(Config config, String connectionURL, String driverClass, String driverPath) throws FileNotFoundException, IOException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Using database properties:");
            this.logger.info("  " + config.getDbPropertiesLoadedFrom());
        } else {
            System.out.println("Using database properties:");
            System.out.println("  " + config.getDbPropertiesLoadedFrom());
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        ArrayList<File> invalidClasspathEntries = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(driverPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File pathElement = new File(tokenizer.nextToken());
            if (pathElement.exists()) {
                classpath.add(pathElement.toURI().toURL());
                continue;
            }
            invalidClasspathEntries.add(pathElement);
        }
        URLClassLoader loader = new URLClassLoader(classpath.toArray(new URL[classpath.size()]));
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(driverClass).newInstance();
        }
        catch (Exception exc) {
            System.err.println(exc);
            System.err.println();
            System.err.print("Failed to load driver '" + driverClass + "'");
            if (classpath.isEmpty()) {
                System.err.println();
            } else {
                System.err.println("from: " + classpath);
            }
            if (!invalidClasspathEntries.isEmpty()) {
                if (invalidClasspathEntries.size() == 1) {
                    System.err.print("This entry doesn't point to a valid file/directory: ");
                } else {
                    System.err.print("These entries don't point to valid files/directories: ");
                }
                System.err.println(invalidClasspathEntries);
            }
            System.err.println();
            System.err.println("Use the -dp option to specify the location of the database");
            System.err.println("drivers for your database (usually in a .jar or .zip/.Z).");
            System.err.println();
            throw new ConnectionFailure(exc);
        }
        Properties connectionProperties = config.getConnectionProperties();
        if (config.getUser() != null) {
            connectionProperties.put("user", config.getUser());
        }
        if (config.getPassword() != null) {
            connectionProperties.put("password", config.getPassword());
        } else if (config.isPromptForPasswordEnabled()) {
            connectionProperties.put("password", new String(PasswordReader.getInstance().readPassword("Password: ", new Object[0])));
        }
        Connection connection = null;
        try {
            connection = driver.connect(connectionURL, connectionProperties);
            if (connection == null) {
                System.err.println();
                System.err.println("Cannot connect to this database URL:");
                System.err.println("  " + connectionURL);
                System.err.println("with this driver:");
                System.err.println("  " + driverClass);
                System.err.println();
                System.err.println("Additional connection information may be available in ");
                System.err.println("  " + config.getDbPropertiesLoadedFrom());
                throw new ConnectionFailure("Cannot connect to '" + connectionURL + "' with driver '" + driverClass + "'");
            }
        }
        catch (UnsatisfiedLinkError badPath) {
            System.err.println();
            System.err.println("Failed to load driver [" + driverClass + "] from classpath " + classpath);
            System.err.println();
            System.err.println("Make sure the reported library (.dll/.lib/.so) from the following line can be");
            System.err.println("found by your PATH (or LIB*PATH) environment variable");
            System.err.println();
            badPath.printStackTrace();
            throw new ConnectionFailure(badPath);
        }
        catch (Exception exc) {
            System.err.println();
            System.err.println("Failed to connect to database URL [" + connectionURL + "]");
            System.err.println();
            exc.printStackTrace();
            throw new ConnectionFailure(exc);
        }
        return connection;
    }

    private static void yankParam(List<String> args, String paramId) {
        int paramIndex = args.indexOf(paramId);
        if (paramIndex >= 0) {
            args.remove(paramIndex);
            args.remove(paramIndex);
        }
    }
}

