/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.xml.ForeignKeyMeta;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableColumnMeta {
    private final String name;
    private final String comments;
    private final boolean isPrimary;
    private final List<ForeignKeyMeta> foreignKeys = new ArrayList<ForeignKeyMeta>();
    private final boolean isExcluded;
    private final boolean isAllExcluded;
    private final boolean isImpliedParentsDisabled;
    private final boolean isImpliedChildrenDisabled;
    private static final Logger logger = Logger.getLogger(TableColumnMeta.class.getName());

    TableColumnMeta(Node colNode) {
        String tmp;
        NamedNodeMap attribs = colNode.getAttributes();
        this.name = attribs.getNamedItem("name").getNodeValue();
        Node node = attribs.getNamedItem("comments");
        this.comments = node != null ? ((tmp = node.getNodeValue().trim()).length() == 0 ? null : tmp) : null;
        node = attribs.getNamedItem("primaryKey");
        this.isPrimary = node != null ? this.evalBoolean(node.getNodeValue()) : false;
        node = attribs.getNamedItem("disableImpliedKeys");
        if (node != null) {
            tmp = node.getNodeValue().trim().toLowerCase();
            if (tmp.equals("to")) {
                this.isImpliedChildrenDisabled = true;
                this.isImpliedParentsDisabled = false;
            } else if (tmp.equals("from")) {
                this.isImpliedParentsDisabled = true;
                this.isImpliedChildrenDisabled = false;
            } else if (tmp.equals("all")) {
                this.isImpliedParentsDisabled = true;
                this.isImpliedChildrenDisabled = true;
            } else {
                this.isImpliedParentsDisabled = false;
                this.isImpliedChildrenDisabled = false;
            }
        } else {
            this.isImpliedParentsDisabled = false;
            this.isImpliedChildrenDisabled = false;
        }
        node = attribs.getNamedItem("disableDiagramAssociations");
        if (node != null) {
            tmp = node.getNodeValue().trim().toLowerCase();
            if (tmp.equals("all")) {
                this.isAllExcluded = true;
                this.isExcluded = true;
            } else if (tmp.equals("exceptdirect")) {
                this.isAllExcluded = false;
                this.isExcluded = true;
            } else {
                this.isAllExcluded = false;
                this.isExcluded = false;
            }
        } else {
            this.isAllExcluded = false;
            this.isExcluded = false;
        }
        logger.finer("Found XML column metadata for " + this.name + " isPrimaryKey: " + this.isPrimary + " comments: " + this.comments);
        NodeList fkNodes = ((Element)((Object)colNode.getChildNodes())).getElementsByTagName("foreignKey");
        for (int i = 0; i < fkNodes.getLength(); ++i) {
            Node fkNode = fkNodes.item(i);
            this.foreignKeys.add(new ForeignKeyMeta(fkNode));
        }
    }

    private boolean evalBoolean(String exp) {
        if (exp == null) {
            return false;
        }
        return (exp = exp.trim().toLowerCase()).equals("true") || exp.equals("yes") || exp.equals("1");
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public List<ForeignKeyMeta> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public boolean isImpliedParentsDisabled() {
        return this.isImpliedParentsDisabled;
    }

    public boolean isImpliedChildrenDisabled() {
        return this.isImpliedChildrenDisabled;
    }
}

