/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.DbSpecificOption;

public class ConnectionURLBuilder {
    private final String connectionURL;
    private final List<DbSpecificOption> options;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ConnectionURLBuilder(Config config, Properties properties) {
        ArrayList<String> opts = new ArrayList<String>();
        for (String key : config.getDbSpecificOptions().keySet()) {
            opts.add((key.startsWith("-") ? "" : "-") + key);
            opts.add(config.getDbSpecificOptions().get(key));
        }
        opts.addAll(config.getRemainingParameters());
        DbSpecificConfig dbConfig = new DbSpecificConfig(config.getDbType());
        this.options = dbConfig.getOptions();
        this.connectionURL = this.buildUrl(opts, properties, config);
        List<String> remaining = config.getRemainingParameters();
        for (DbSpecificOption option : this.options) {
            int idx = remaining.indexOf("-" + option.getName());
            if (idx < 0) continue;
            remaining.remove(idx);
            remaining.remove(idx);
        }
        this.logger.config("connectionURL: " + this.connectionURL);
    }

    private String buildUrl(List<String> args, Properties properties, Config config) {
        String connectionSpec = properties.getProperty("connectionSpec");
        for (DbSpecificOption option : this.options) {
            option.setValue(this.getParam(args, option, config));
            connectionSpec = connectionSpec.replaceAll("\\<" + option.getName() + "\\>", option.getValue().toString());
        }
        return connectionSpec;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public List<DbSpecificOption> getOptions() {
        return this.options;
    }

    private String getParam(List<String> args, DbSpecificOption option, Config config) {
        String param = null;
        int paramIndex = args.indexOf("-" + option.getName());
        if (paramIndex < 0) {
            if (config != null) {
                param = config.getParam(option.getName());
            }
            if (param == null) {
                throw new Config.MissingRequiredParameterException(option.getName(), option.getDescription(), true);
            }
        } else {
            args.remove(paramIndex);
            param = args.get(paramIndex).toString();
            args.remove(paramIndex);
        }
        return param;
    }
}

