/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.Revision;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.DotConnector;
import net.sourceforge.schemaspy.view.DotConnectorFinder;
import net.sourceforge.schemaspy.view.DotNode;
import net.sourceforge.schemaspy.view.StyleSheet;
import net.sourceforge.schemaspy.view.WriteStats;

public class DotFormatter {
    private static DotFormatter instance = new DotFormatter();
    private final int fontSize = Config.getInstance().getFontSize();

    private DotFormatter() {
    }

    public static DotFormatter getInstance() {
        return instance;
    }

    public Set<ForeignKeyConstraint> writeRealRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, LineWriter dot) throws IOException {
        return this.writeRelationships(table, twoDegreesOfSeparation, stats, false, dot);
    }

    public void writeAllRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, LineWriter dot) throws IOException {
        this.writeRelationships(table, twoDegreesOfSeparation, stats, true, dot);
    }

    private Set<ForeignKeyConstraint> writeRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, boolean includeImplied, LineWriter dot) throws IOException {
        HashSet<Table> tablesWritten = new HashSet<Table>();
        HashSet<ForeignKeyConstraint> skippedImpliedConstraints = new HashSet<ForeignKeyConstraint>();
        DotConnectorFinder finder = DotConnectorFinder.getInstance();
        String diagramName = includeImplied ? "impliedTwoDegreesRelationshipsDiagram" : (twoDegreesOfSeparation ? "twoDegreesRelationshipsDiagram" : "oneDegreeRelationshipsDiagram");
        this.writeHeader(diagramName, true, dot);
        Set<Table> relatedTables = this.getImmediateRelatives(table, true, includeImplied, skippedImpliedConstraints);
        TreeSet<DotConnector> connectors = new TreeSet<DotConnector>(finder.getRelatedConnectors(table, includeImplied));
        tablesWritten.add(table);
        TreeMap<Table, DotNode> nodes = new TreeMap<Table, DotNode>();
        for (Table relatedTable : relatedTables) {
            if (!tablesWritten.add(relatedTable)) continue;
            nodes.put(relatedTable, new DotNode(relatedTable, true, ""));
            connectors.addAll(finder.getRelatedConnectors(relatedTable, table, true, includeImplied));
        }
        for (DotConnector connector : connectors) {
            if (!connector.pointsTo(table)) continue;
            connector.connectToParentDetails();
        }
        HashSet<Table> allCousins = new HashSet<Table>();
        TreeSet<DotConnector> allCousinConnectors = new TreeSet<DotConnector>();
        if (twoDegreesOfSeparation) {
            for (Table relatedTable : relatedTables) {
                Set<Table> cousins = this.getImmediateRelatives(relatedTable, false, includeImplied, skippedImpliedConstraints);
                for (Table cousin : cousins) {
                    if (!tablesWritten.add(cousin)) continue;
                    allCousinConnectors.addAll(finder.getRelatedConnectors(cousin, relatedTable, false, includeImplied));
                    nodes.put(cousin, new DotNode(cousin, false, ""));
                }
                allCousins.addAll(cousins);
            }
        }
        ArrayList participants = new ArrayList(nodes.keySet());
        Iterator iter = participants.iterator();
        while (iter.hasNext()) {
            Table participantA = (Table)iter.next();
            iter.remove();
            for (Table participantB : participants) {
                for (DotConnector connector : finder.getRelatedConnectors(participantA, participantB, false, includeImplied)) {
                    if (twoDegreesOfSeparation && (allCousins.contains(participantA) || allCousins.contains(participantB))) {
                        allCousinConnectors.add(connector);
                        continue;
                    }
                    connectors.add(connector);
                }
            }
        }
        this.markExcludedColumns(nodes, stats.getExcludedColumns());
        for (DotConnector connector : allCousinConnectors) {
            if (allCousins.contains(connector.getParentTable()) && !relatedTables.contains(connector.getParentTable())) {
                connector.connectToParentTitle();
            }
            if (!allCousins.contains(connector.getChildTable()) || relatedTables.contains(connector.getChildTable())) continue;
            connector.connectToChildTitle();
        }
        nodes.put(table, new DotNode(table, ""));
        connectors.addAll(allCousinConnectors);
        for (DotConnector connector : connectors) {
            if (connector.isImplied()) {
                DotNode node = (DotNode)nodes.get(connector.getParentTable());
                if (node != null) {
                    node.setShowImplied(true);
                }
                if ((node = (DotNode)nodes.get(connector.getChildTable())) != null) {
                    node.setShowImplied(true);
                }
            }
            dot.writeln(connector.toString());
        }
        for (DotNode node : nodes.values()) {
            dot.writeln(node.toString());
            stats.wroteTable(node.getTable());
        }
        dot.writeln("}");
        return skippedImpliedConstraints;
    }

    private Set<Table> getImmediateRelatives(Table table, boolean includeExcluded, boolean includeImplied, Set<ForeignKeyConstraint> skippedImpliedConstraints) {
        HashSet<TableColumn> relatedColumns = new HashSet<TableColumn>();
        for (TableColumn column : table.getColumns()) {
            ForeignKeyConstraint constraint;
            if (column.isAllExcluded() || !includeExcluded && column.isExcluded()) continue;
            for (TableColumn childColumn : column.getChildren()) {
                if (childColumn.isAllExcluded() || !includeExcluded && childColumn.isExcluded()) continue;
                constraint = column.getChildConstraint(childColumn);
                if (includeImplied || !constraint.isImplied()) {
                    relatedColumns.add(childColumn);
                    continue;
                }
                skippedImpliedConstraints.add(constraint);
            }
            for (TableColumn parentColumn : column.getParents()) {
                if (parentColumn.isAllExcluded() || !includeExcluded && parentColumn.isExcluded()) continue;
                constraint = column.getParentConstraint(parentColumn);
                if (includeImplied || !constraint.isImplied()) {
                    relatedColumns.add(parentColumn);
                    continue;
                }
                skippedImpliedConstraints.add(constraint);
            }
        }
        HashSet<Table> relatedTables = new HashSet<Table>();
        for (TableColumn column : relatedColumns) {
            relatedTables.add(column.getTable());
        }
        relatedTables.remove(table);
        return relatedTables;
    }

    private void writeHeader(String diagramName, boolean showLabel, LineWriter dot) throws IOException {
        dot.writeln("// dot " + Dot.getInstance().getVersion() + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        dot.writeln("// SchemaSpy rev " + new Revision());
        dot.writeln("digraph \"" + diagramName + "\" {");
        dot.writeln("  graph [");
        boolean rankdirbug = Config.getInstance().isRankDirBugEnabled();
        if (!rankdirbug) {
            dot.writeln("    rankdir=\"RL\"");
        }
        dot.writeln("    bgcolor=\"" + StyleSheet.getInstance().getBodyBackground() + "\"");
        if (showLabel) {
            if (rankdirbug) {
                dot.writeln("    label=\"\\nLayout is significantly better without '-rankdirbug' option\"");
            } else {
                dot.writeln("    label=\"\\nGenerated by SchemaSpy\"");
            }
            dot.writeln("    labeljust=\"l\"");
        }
        dot.writeln("    nodesep=\"0.18\"");
        dot.writeln("    ranksep=\"0.46\"");
        dot.writeln("    fontname=\"" + Config.getInstance().getFont() + "\"");
        dot.writeln("    fontsize=\"" + this.fontSize + "\"");
        dot.writeln("  ];");
        dot.writeln("  node [");
        dot.writeln("    fontname=\"" + Config.getInstance().getFont() + "\"");
        dot.writeln("    fontsize=\"" + this.fontSize + "\"");
        dot.writeln("    shape=\"plaintext\"");
        dot.writeln("  ];");
        dot.writeln("  edge [");
        dot.writeln("    arrowsize=\"0.8\"");
        dot.writeln("  ];");
    }

    public void writeRealRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, WriteStats stats, LineWriter dot) throws IOException {
        this.writeRelationships(db, tables, compact, showColumns, false, stats, dot);
    }

    public boolean writeAllRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, WriteStats stats, LineWriter dot) throws IOException {
        return this.writeRelationships(db, tables, compact, showColumns, true, stats, dot);
    }

    private boolean writeRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, boolean includeImplied, WriteStats stats, LineWriter dot) throws IOException {
        DotConnectorFinder finder = DotConnectorFinder.getInstance();
        DotNode.DotNodeConfig nodeConfig = showColumns ? new DotNode.DotNodeConfig(!compact, false) : new DotNode.DotNodeConfig();
        boolean wroteImplied = false;
        String diagramName = includeImplied ? (compact ? "compactImpliedRelationshipsDiagram" : "largeImpliedRelationshipsDiagram") : (compact ? "compactRelationshipsDiagram" : "largeRelationshipsDiagram");
        this.writeHeader(diagramName, true, dot);
        TreeMap<Table, DotNode> nodes = new TreeMap<Table, DotNode>();
        for (Table table : tables) {
            if (table.isOrphan(includeImplied)) continue;
            nodes.put(table, new DotNode(table, "tables/", nodeConfig));
        }
        for (Table table : db.getRemoteTables()) {
            nodes.put(table, new DotNode(table, "tables/", nodeConfig));
        }
        TreeSet<DotConnector> connectors = new TreeSet<DotConnector>();
        for (DotNode node : nodes.values()) {
            connectors.addAll(finder.getRelatedConnectors(node.getTable(), includeImplied));
        }
        this.markExcludedColumns(nodes, stats.getExcludedColumns());
        for (DotNode node : nodes.values()) {
            Table table = node.getTable();
            dot.writeln(node.toString());
            stats.wroteTable(table);
            wroteImplied = wroteImplied || includeImplied && table.isOrphan(false);
        }
        for (DotConnector connector : connectors) {
            dot.writeln(connector.toString());
        }
        dot.writeln("}");
        return wroteImplied;
    }

    private void markExcludedColumns(Map<Table, DotNode> nodes, Set<TableColumn> excludedColumns) {
        for (TableColumn column : excludedColumns) {
            DotNode node = nodes.get(column.getTable());
            if (node == null) continue;
            node.excludeColumn(column);
        }
    }

    public void writeOrphan(Table table, LineWriter dot) throws IOException {
        this.writeHeader(table.getName(), false, dot);
        dot.writeln(new DotNode(table, true, "tables/").toString());
        dot.writeln("}");
    }
}

