/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.view.StyleSheet;

public class DotNode {
    private final Table table;
    private final DotNodeConfig config;
    private final String path;
    private final Set<TableColumn> excludedColumns = new HashSet<TableColumn>();
    private final String lineSeparator = System.getProperty("line.separator");
    private final boolean displayNumRows = Config.getInstance().isNumRowsEnabled();

    public DotNode(Table table, String path) {
        this(table, path, new DotNodeConfig(true, true));
    }

    public DotNode(Table table, String path, DotNodeConfig config) {
        this.table = table;
        this.path = path + (table.isRemote() ? "../../" + table.getSchema() + "/tables/" : "");
        this.config = config;
    }

    public DotNode(Table table, boolean showColumns, String path) {
        this(table, path, showColumns ? new DotNodeConfig(true, false) : new DotNodeConfig());
    }

    public void setShowImplied(boolean showImplied) {
        this.config.showImpliedRelationships = showImplied;
    }

    public Table getTable() {
        return this.table;
    }

    public void excludeColumn(TableColumn column) {
        this.excludedColumns.add(column);
    }

    public String toString() {
        int numChildren;
        int numParents;
        StyleSheet css = StyleSheet.getInstance();
        StringBuilder buf = new StringBuilder();
        String tableName = this.table.getName();
        String fqTableName = (this.table.isRemote() ? this.table.getSchema() + "." : "") + tableName;
        String colspan = this.config.showColumnDetails ? "COLSPAN=\"2\" " : "COLSPAN=\"3\" ";
        buf.append("  \"" + fqTableName + "\" [" + this.lineSeparator);
        buf.append("    label=<" + this.lineSeparator);
        buf.append("    <TABLE BORDER=\"" + (this.config.showColumnDetails ? "2" : "0") + "\" CELLBORDER=\"1\" CELLSPACING=\"0\" BGCOLOR=\"" + css.getTableBackground() + "\">" + this.lineSeparator);
        buf.append("      <TR>");
        buf.append("<TD COLSPAN=\"3\" BGCOLOR=\"" + css.getTableHeadBackground() + "\" ALIGN=\"CENTER\">" + fqTableName + "</TD>");
        buf.append("</TR>" + this.lineSeparator);
        boolean skippedTrivial = false;
        if (this.config.showColumns) {
            List<TableColumn> primaryColumns = this.table.getPrimaryColumns();
            HashSet<TableColumn> indexColumns = new HashSet<TableColumn>();
            for (TableIndex index : this.table.getIndexes()) {
                indexColumns.addAll(index.getColumns());
            }
            indexColumns.removeAll(primaryColumns);
            for (TableColumn column : this.table.getColumns()) {
                if (this.config.showTrivialColumns || this.config.showColumnDetails || column.isPrimary() || column.isForeignKey() || indexColumns.contains(column)) {
                    buf.append("      <TR>");
                    buf.append("<TD PORT=\"" + column.getName() + "\" " + colspan);
                    if (this.excludedColumns.contains(column)) {
                        buf.append("BGCOLOR=\"" + css.getExcludedColumnBackgroundColor() + "\" ");
                    } else if (primaryColumns.contains(column)) {
                        buf.append("BGCOLOR=\"" + css.getPrimaryKeyBackground() + "\" ");
                    } else if (indexColumns.contains(column)) {
                        buf.append("BGCOLOR=\"" + css.getIndexedColumnBackground() + "\" ");
                    }
                    buf.append("ALIGN=\"LEFT\">");
                    buf.append(column.getName());
                    buf.append("</TD>");
                    if (this.config.showColumnDetails) {
                        buf.append("<TD PORT=\"");
                        buf.append(column.getName());
                        buf.append(".type\" ALIGN=\"LEFT\">");
                        buf.append(column.getType().toLowerCase());
                        buf.append("[");
                        buf.append(column.getDetailedSize());
                        buf.append("]</TD>");
                    }
                    buf.append("</TR>" + this.lineSeparator);
                    continue;
                }
                skippedTrivial = true;
            }
        }
        if (skippedTrivial || !this.config.showColumns) {
            buf.append("      <TR><TD PORT=\"elipses\" COLSPAN=\"3\" ALIGN=\"LEFT\">...</TD></TR>" + this.lineSeparator);
        }
        buf.append("      <TR>");
        buf.append("<TD ALIGN=\"LEFT\" BGCOLOR=\"" + css.getBodyBackground() + "\">");
        int n = numParents = this.config.showImpliedRelationships ? this.table.getNumParents() : this.table.getNumNonImpliedParents();
        if (numParents > 0 || this.config.showColumnDetails) {
            buf.append("&lt; " + numParents);
        } else {
            buf.append("  ");
        }
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + css.getBodyBackground() + "\">");
        if (this.table.isView()) {
            buf.append("view");
        } else {
            int numRows = this.table.getNumRows();
            if (this.displayNumRows && numRows != -1) {
                buf.append(NumberFormat.getInstance().format(numRows));
                buf.append(" row");
                if (numRows != 1) {
                    buf.append('s');
                }
            } else {
                buf.append("  ");
            }
        }
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + css.getBodyBackground() + "\">");
        int n2 = numChildren = this.config.showImpliedRelationships ? this.table.getNumChildren() : this.table.getNumNonImpliedChildren();
        if (numChildren > 0 || this.config.showColumnDetails) {
            buf.append(numChildren + " &gt;");
        } else {
            buf.append("  ");
        }
        buf.append("</TD></TR>" + this.lineSeparator);
        buf.append("    </TABLE>>" + this.lineSeparator);
        if (!this.table.isRemote() || Config.getInstance().isOneOfMultipleSchemas()) {
            buf.append("    URL=\"" + this.path + DotNode.toNCR(tableName) + ".html\"" + this.lineSeparator);
        }
        buf.append("    tooltip=\"" + DotNode.toNCR(fqTableName) + "\"" + this.lineSeparator);
        buf.append("  ];");
        return buf.toString();
    }

    private static String toNCR(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch <= '\u007f') {
                result.append(ch);
                continue;
            }
            result.append("&#");
            result.append(Integer.parseInt(Integer.toHexString(ch), 16));
            result.append(";");
        }
        return result.toString();
    }

    public static class DotNodeConfig {
        private final boolean showColumns;
        private boolean showTrivialColumns;
        private final boolean showColumnDetails;
        private boolean showImpliedRelationships;

        public DotNodeConfig() {
            this.showImpliedRelationships = false;
            this.showColumnDetails = false;
            this.showTrivialColumns = false;
            this.showColumns = false;
        }

        public DotNodeConfig(boolean showTrivialColumns, boolean showColumnDetails) {
            this.showColumns = true;
            this.showTrivialColumns = showTrivialColumns;
            this.showColumnDetails = showColumnDetails;
        }
    }
}

