/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.ExplicitRemoteTable;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.RemoteTable;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.View;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;

public class Database {
    private final String databaseName;
    private final String schema;
    private String description;
    private final Map<String, Table> tables = new CaseInsensitiveMap<Table>();
    private final Map<String, View> views = new CaseInsensitiveMap<View>();
    private final Map<String, Table> remoteTables = new CaseInsensitiveMap<Table>();
    private final DatabaseMetaData meta;
    private final Connection connection;
    private final String connectTime = new SimpleDateFormat("EEE MMM dd HH:mm z yyyy").format(new Date());
    private Set<String> sqlKeywords;
    private Pattern invalidIdentifierPattern;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final boolean fineEnabled = this.logger.isLoggable(Level.FINE);

    public Database(Config config, Connection connection, DatabaseMetaData meta, String name, String schema, Properties properties, SchemaMeta schemaMeta) throws SQLException, MissingResourceException {
        this.connection = connection;
        this.meta = meta;
        this.databaseName = name;
        this.schema = schema;
        this.description = config.getDescription();
        this.initTables(meta, properties, config);
        if (config.isViewsEnabled()) {
            this.initViews(meta, properties, config);
        }
        this.initCheckConstraints(properties);
        this.initTableIds(properties);
        this.initIndexIds(properties);
        this.initTableComments(properties);
        this.initTableColumnComments(properties);
        this.initViewComments(properties);
        this.initViewColumnComments(properties);
        this.connectTables();
        this.updateFromXmlMetadata(schemaMeta);
    }

    public String getName() {
        return this.databaseName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Map<String, Table> getTablesByName() {
        return this.tables;
    }

    public Collection<View> getViews() {
        return this.views.values();
    }

    public Collection<Table> getRemoteTables() {
        return this.remoteTables.values();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getMetaData() {
        return this.meta;
    }

    public String getConnectTime() {
        return this.connectTime;
    }

    public String getDatabaseProduct() {
        try {
            return this.meta.getDatabaseProductName() + " - " + this.meta.getDatabaseProductVersion();
        }
        catch (SQLException exc) {
            return "";
        }
    }

    private void initTables(DatabaseMetaData metadata, Properties properties, Config config) throws SQLException {
        TableCreator creator;
        Pattern include = config.getTableInclusions();
        Pattern exclude = config.getTableExclusions();
        int maxThreads = config.getMaxDbThreads();
        String[] types = this.getTypes("tableTypes", "TABLE", properties);
        NameValidator validator = new NameValidator("table", include, exclude, types);
        List<BasicTableMeta> entries = this.getBasicTableMeta(metadata, true, properties, types);
        if (maxThreads == 1) {
            creator = new TableCreator();
        } else {
            creator = new ThreadedTableCreator(maxThreads);
            while (!entries.isEmpty()) {
                BasicTableMeta entry = entries.remove(0);
                if (!validator.isValid(entry.name, entry.type)) continue;
                new TableCreator().create(entry, properties);
                break;
            }
        }
        for (BasicTableMeta entry : entries) {
            if (!validator.isValid(entry.name, entry.type)) continue;
            creator.create(entry, properties);
        }
        creator.join();
    }

    private void initViews(DatabaseMetaData metadata, Properties properties, Config config) throws SQLException {
        Pattern includeTables = config.getTableInclusions();
        Pattern excludeTables = config.getTableExclusions();
        Pattern excludeColumns = config.getColumnExclusions();
        Pattern excludeIndirectColumns = config.getIndirectColumnExclusions();
        String[] types = this.getTypes("viewTypes", "VIEW", properties);
        NameValidator validator = new NameValidator("view", includeTables, excludeTables, types);
        for (BasicTableMeta entry : this.getBasicTableMeta(metadata, false, properties, types)) {
            if (!validator.isValid(entry.name, entry.type)) continue;
            View view = new View(this, entry.schema, entry.name, entry.remarks, entry.viewSql, properties, excludeIndirectColumns, excludeColumns);
            this.views.put(view.getName(), view);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Found details of view " + view.getName());
                continue;
            }
            System.out.print('.');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicTableMeta> getBasicTableMeta(DatabaseMetaData metadata, boolean forTables, Properties properties, String ... types) throws SQLException {
        String queryName = forTables ? "selectTablesSql" : "selectViewsSql";
        String sql = properties.getProperty(queryName);
        ArrayList<BasicTableMeta> basics = new ArrayList<BasicTableMeta>();
        ResultSet rs = null;
        if (sql != null) {
            String clazz = forTables ? "table" : "view";
            PreparedStatement stmt = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(clazz + "_name");
                    String sch = this.getOptionalString(rs, clazz + "_schema");
                    if (sch == null) {
                        sch = this.schema;
                    }
                    String remarks = this.getOptionalString(rs, clazz + "_comment");
                    String text = forTables ? null : this.getOptionalString(rs, "view_definition");
                    String rows = forTables ? this.getOptionalString(rs, "table_rows") : null;
                    int numRows = rows == null ? -1 : Integer.parseInt(rows);
                    basics.add(new BasicTableMeta(sch, name, clazz, remarks, text, numRows));
                }
            }
            catch (SQLException sqlException) {
                System.out.flush();
                System.err.println();
                System.err.println("Failed to retrieve " + clazz + " names with custom SQL: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        if (basics.isEmpty()) {
            rs = metadata.getTables(null, this.schema, "%", types);
            try {
                while (rs.next()) {
                    String name = rs.getString("TABLE_NAME");
                    String type = rs.getString("TABLE_TYPE");
                    String schem = rs.getString("TABLE_SCHEM");
                    String remarks = this.getOptionalString(rs, "REMARKS");
                    basics.add(new BasicTableMeta(schem, name, type, remarks, null, -1));
                }
            }
            catch (SQLException exc) {
                if (forTables) {
                    throw exc;
                }
                System.out.flush();
                System.err.println();
                System.err.println("Ignoring view " + rs.getString("TABLE_NAME") + " due to exception:");
                exc.printStackTrace();
                System.err.println("Continuing analysis.");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return basics;
    }

    private String[] getTypes(String propName, String defaultValue, Properties props) {
        String value = props.getProperty(propName, defaultValue);
        ArrayList<String> types = new ArrayList<String>();
        for (String type : value.split(",")) {
            if ((type = type.trim()).length() <= 0) continue;
            types.add(type);
        }
        return types.toArray(new String[types.size()]);
    }

    public String getOptionalString(ResultSet rs, String columnName) {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCheckConstraints(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectCheckConstraintsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = this.tables.get(tableName);
                    if (table == null) continue;
                    table.addCheckConstraint(rs.getString("constraint_name"), rs.getString("text"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println("Failed to retrieve check constraints: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void initTableIds(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectTableIdsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = this.tables.get(tableName);
                    if (table == null) continue;
                    table.setId(rs.getObject("table_id"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println(sql);
                throw sqlException;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void initIndexIds(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectIndexIdsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TableIndex index;
                    String tableName = rs.getString("table_name");
                    Table table = this.tables.get(tableName);
                    if (table == null || (index = table.getIndex(rs.getString("index_name"))) == null) continue;
                    index.setId(rs.getObject("index_id"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println(sql);
                throw sqlException;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableComments(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectTableCommentsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = this.tables.get(tableName);
                    if (table == null) {
                        table = this.views.get(tableName);
                    }
                    if (table == null) continue;
                    table.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println("Failed to retrieve table/view comments: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewComments(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectViewCommentsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Table view;
                    String viewName = rs.getString("view_name");
                    if (viewName == null) {
                        viewName = rs.getString("table_name");
                    }
                    if ((view = (Table)this.views.get(viewName)) == null) continue;
                    view.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println("Failed to retrieve table/view comments: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableColumnComments(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectColumnCommentsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TableColumn column;
                    String tableName = rs.getString("table_name");
                    Table table = this.tables.get(tableName);
                    if (table == null) {
                        table = this.views.get(tableName);
                    }
                    if (table == null || (column = table.getColumn(rs.getString("column_name"))) == null) continue;
                    column.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println("Failed to retrieve column comments: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewColumnComments(Properties properties) throws SQLException {
        String sql = properties.getProperty("selectViewColumnCommentsSql");
        if (sql != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TableColumn column;
                    Table view;
                    String viewName = rs.getString("view_name");
                    if (viewName == null) {
                        viewName = rs.getString("table_name");
                    }
                    if ((view = (Table)this.views.get(viewName)) == null || (column = view.getColumn(rs.getString("column_name"))) == null) continue;
                    column.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                System.err.println();
                System.err.println("Failed to retrieve view column comments: " + sqlException);
                System.err.println(sql);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public PreparedStatement prepareStatement(String sql, String tableName) throws SQLException {
        StringBuilder sqlBuf = new StringBuilder(sql);
        List<String> sqlParams = this.getSqlParams(sqlBuf, tableName);
        PreparedStatement stmt = this.getConnection().prepareStatement(sqlBuf.toString());
        try {
            for (int i = 0; i < sqlParams.size(); ++i) {
                stmt.setString(i + 1, sqlParams.get(i).toString());
            }
        }
        catch (SQLException exc) {
            stmt.close();
            throw exc;
        }
        return stmt;
    }

    public Table addRemoteTable(String remoteSchema, String remoteTableName, String baseSchema, Properties properties, Pattern excludeIndirectColumns, Pattern excludeColumns) throws SQLException {
        String fullName = remoteSchema + "." + remoteTableName;
        Table remoteTable = this.remoteTables.get(fullName);
        if (remoteTable == null) {
            remoteTable = properties != null ? new RemoteTable(this, remoteSchema, remoteTableName, baseSchema, properties, excludeIndirectColumns, excludeColumns) : new ExplicitRemoteTable(this, remoteSchema, remoteTableName, baseSchema);
            this.logger.fine("Adding remote table " + fullName);
            remoteTable.connectForeignKeys(this.tables, excludeIndirectColumns, excludeColumns);
            this.remoteTables.put(fullName, remoteTable);
        }
        return remoteTable;
    }

    public Set<String> getSqlKeywords() throws SQLException {
        if (this.sqlKeywords == null) {
            String[] sql92Keywords = "ADA| C | CATALOG_NAME | CHARACTER_SET_CATALOG | CHARACTER_SET_NAME| CHARACTER_SET_SCHEMA | CLASS_ORIGIN | COBOL | COLLATION_CATALOG| COLLATION_NAME | COLLATION_SCHEMA | COLUMN_NAME | COMMAND_FUNCTION | COMMITTED| CONDITION_NUMBER | CONNECTION_NAME | CONSTRAINT_CATALOG | CONSTRAINT_NAME| CONSTRAINT_SCHEMA | CURSOR_NAME| DATA | DATETIME_INTERVAL_CODE | DATETIME_INTERVAL_PRECISION | DYNAMIC_FUNCTION| FORTRAN| LENGTH| MESSAGE_LENGTH | MESSAGE_OCTET_LENGTH | MESSAGE_TEXT | MORE | MUMPS| NAME | NULLABLE | NUMBER| PASCAL | PLI| REPEATABLE | RETURNED_LENGTH | RETURNED_OCTET_LENGTH | RETURNED_SQLSTATE| ROW_COUNT| SCALE | SCHEMA_NAME | SERIALIZABLE | SERVER_NAME | SUBCLASS_ORIGIN| TABLE_NAME | TYPE| UNCOMMITTED | UNNAMED| ABSOLUTE | ACTION | ADD | ALL | ALLOCATE | ALTER | AND| ANY | ARE | AS | ASC| ASSERTION | AT | AUTHORIZATION | AVG| BEGIN | BETWEEN | BIT | BIT_LENGTH | BOTH | BY| CASCADE | CASCADED | CASE | CAST | CATALOG | CHAR | CHARACTER | CHAR_LENGTH| CHARACTER_LENGTH | CHECK | CLOSE | COALESCE | COLLATE | COLLATION| COLUMN | COMMIT | CONNECT | CONNECTION | CONSTRAINT| CONSTRAINTS | CONTINUE| CONVERT | CORRESPONDING | COUNT | CREATE | CROSS | CURRENT| CURRENT_DATE | CURRENT_TIME | CURRENT_TIMESTAMP | CURRENT_USER | CURSOR| DATE | DAY | DEALLOCATE | DEC | DECIMAL | DECLARE | DEFAULT | DEFERRABLE| DEFERRED | DELETE | DESC | DESCRIBE | DESCRIPTOR | DIAGNOSTICS| DISCONNECT | DISTINCT | DOMAIN | DOUBLE | DROP| ELSE | END | END-EXEC | ESCAPE | EXCEPT | EXCEPTION| EXEC | EXECUTE | EXISTS| EXTERNAL | EXTRACT| FALSE | FETCH | FIRST | FLOAT | FOR | FOREIGN | FOUND | FROM | FULL| GET | GLOBAL | GO | GOTO | GRANT | GROUP| HAVING | HOUR| IDENTITY | IMMEDIATE | IN | INDICATOR | INITIALLY | INNER | INPUT| INSENSITIVE | INSERT | INT | INTEGER | INTERSECT | INTERVAL | INTO | IS| ISOLATION| JOIN| KEY| LANGUAGE | LAST | LEADING | LEFT | LEVEL | LIKE | LOCAL | LOWER| MATCH | MAX | MIN | MINUTE | MODULE | MONTH| NAMES | NATIONAL | NATURAL | NCHAR | NEXT | NO | NOT | NULL| NULLIF | NUMERIC| OCTET_LENGTH | OF | ON | ONLY | OPEN | OPTION | OR| ORDER | OUTER| OUTPUT | OVERLAPS| PAD | PARTIAL | POSITION | PRECISION | PREPARE | PRESERVE | PRIMARY| PRIOR | PRIVILEGES | PROCEDURE | PUBLIC| READ | REAL | REFERENCES | RELATIVE | RESTRICT | REVOKE | RIGHT| ROLLBACK | ROWS| SCHEMA | SCROLL | SECOND | SECTION | SELECT | SESSION | SESSION_USER | SET| SIZE | SMALLINT | SOME | SPACE | SQL | SQLCODE | SQLERROR | SQLSTATE| SUBSTRING | SUM | SYSTEM_USER| TABLE | TEMPORARY | THEN | TIME | TIMESTAMP | TIMEZONE_HOUR | TIMEZONE_MINUTE| TO | TRAILING | TRANSACTION | TRANSLATE | TRANSLATION | TRIM | TRUE| UNION | UNIQUE | UNKNOWN | UPDATE | UPPER | USAGE | USER | USING| VALUE | VALUES | VARCHAR | VARYING | VIEW| WHEN | WHENEVER | WHERE | WITH | WORK | WRITE| YEAR| ZONE".split("|,\\s*");
            String[] nonSql92Keywords = this.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*");
            this.sqlKeywords = new HashSet<String>();
            this.sqlKeywords.addAll(Arrays.asList(sql92Keywords));
            this.sqlKeywords.addAll(Arrays.asList(nonSql92Keywords));
        }
        return this.sqlKeywords;
    }

    public String getQuotedIdentifier(String id) throws SQLException {
        boolean quotesRequired;
        Matcher matcher = this.getInvalidIdentifierPattern().matcher(id);
        boolean bl = quotesRequired = matcher.find() || this.getSqlKeywords().contains(id.toUpperCase());
        if (quotesRequired) {
            String quote = this.getMetaData().getIdentifierQuoteString().trim();
            return quote + id + quote;
        }
        return id;
    }

    private Pattern getInvalidIdentifierPattern() throws SQLException {
        if (this.invalidIdentifierPattern == null) {
            String validChars = "a-zA-Z0-9_";
            String reservedRegexChars = "-&^";
            String extraValidChars = this.getMetaData().getExtraNameCharacters();
            for (int i = 0; i < extraValidChars.length(); ++i) {
                char ch = extraValidChars.charAt(i);
                if (reservedRegexChars.indexOf(ch) >= 0) {
                    validChars = validChars + "\\";
                }
                validChars = validChars + ch;
            }
            this.invalidIdentifierPattern = Pattern.compile("[^" + validChars + "]");
        }
        return this.invalidIdentifierPattern;
    }

    private List<String> getSqlParams(StringBuilder sql, String tableName) {
        HashMap<String, String> namedParams = new HashMap<String, String>();
        String schema = this.getSchema();
        if (schema == null) {
            schema = this.getName();
        }
        namedParams.put(":schema", schema);
        namedParams.put(":owner", schema);
        if (tableName != null) {
            namedParams.put(":table", tableName);
            namedParams.put(":view", tableName);
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        int nextColon = sql.indexOf(":");
        while (nextColon != -1) {
            String paramName = new StringTokenizer(sql.substring(nextColon), " ,\"')").nextToken();
            String paramValue = (String)namedParams.get(paramName);
            if (paramValue == null) {
                throw new InvalidConfigurationException("Unexpected named parameter '" + paramName + "' found in SQL '" + sql + "'");
            }
            sqlParams.add(paramValue);
            sql.replace(nextColon, nextColon + paramName.length(), "?");
            nextColon = sql.indexOf(":", nextColon);
        }
        return sqlParams;
    }

    private void updateFromXmlMetadata(SchemaMeta schemaMeta) throws SQLException {
        if (schemaMeta != null) {
            Table table;
            Pattern excludeNone = Pattern.compile("[^.]");
            Properties noProps = new Properties();
            this.description = schemaMeta.getComments();
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                if (tableMeta.getRemoteSchema() != null) {
                    table = this.remoteTables.get(tableMeta.getRemoteSchema() + '.' + tableMeta.getName());
                    if (table == null) {
                        table = this.addRemoteTable(tableMeta.getRemoteSchema(), tableMeta.getName(), this.getSchema(), null, excludeNone, excludeNone);
                    }
                } else {
                    table = this.tables.get(tableMeta.getName());
                    if (table == null) {
                        table = this.views.get(tableMeta.getName());
                    }
                    if (table == null) {
                        table = new Table(this, this.getSchema(), tableMeta.getName(), null, noProps, excludeNone, excludeNone);
                        this.tables.put(table.getName(), table);
                    }
                }
                table.update(tableMeta);
            }
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                if (tableMeta.getRemoteSchema() != null) {
                    table = this.remoteTables.get(tableMeta.getRemoteSchema() + '.' + tableMeta.getName());
                } else {
                    table = this.tables.get(tableMeta.getName());
                    if (table == null) {
                        table = this.views.get(tableMeta.getName());
                    }
                }
                table.connect(tableMeta, this.tables, this.remoteTables);
            }
        }
    }

    private void connectTables() throws SQLException {
        Pattern excludeColumns = Config.getInstance().getColumnExclusions();
        Pattern excludeIndirectColumns = Config.getInstance().getIndirectColumnExclusions();
        for (Table table : this.tables.values()) {
            table.connectForeignKeys(this.tables, excludeIndirectColumns, excludeColumns);
        }
    }

    private class ThreadedTableCreator
    extends TableCreator {
        private final Set<Thread> threads;
        private final int maxThreads;

        ThreadedTableCreator(int maxThreads) {
            this.threads = new HashSet<Thread>();
            this.maxThreads = maxThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void create(final BasicTableMeta tableMeta, final Properties properties) throws SQLException {
            Thread runner = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ThreadedTableCreator.this.createImpl(tableMeta, properties);
                    }
                    catch (SQLException exc) {
                        exc.printStackTrace();
                    }
                    finally {
                        Set set = ThreadedTableCreator.this.threads;
                        synchronized (set) {
                            ThreadedTableCreator.this.threads.remove(this);
                            ThreadedTableCreator.this.threads.notify();
                        }
                    }
                }
            };
            Set<Thread> set = this.threads;
            synchronized (set) {
                while (this.threads.size() >= this.maxThreads) {
                    try {
                        this.threads.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.threads.add(runner);
            }
            runner.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void join() {
            while (true) {
                Thread thread;
                Set<Thread> set = this.threads;
                synchronized (set) {
                    Iterator<Thread> iter = this.threads.iterator();
                    if (!iter.hasNext()) {
                        break;
                    }
                    thread = iter.next();
                }
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class TableCreator {
        private final Pattern excludeColumns = Config.getInstance().getColumnExclusions();
        private final Pattern excludeIndirectColumns = Config.getInstance().getIndirectColumnExclusions();

        private TableCreator() {
        }

        void create(BasicTableMeta tableMeta, Properties properties) throws SQLException {
            this.createImpl(tableMeta, properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createImpl(BasicTableMeta tableMeta, Properties properties) throws SQLException {
            Table table = new Table(Database.this, tableMeta.schema, tableMeta.name, tableMeta.remarks, properties, this.excludeIndirectColumns, this.excludeColumns);
            if (tableMeta.numRows != -1) {
                table.setNumRows(tableMeta.numRows);
            }
            Map map = Database.this.tables;
            synchronized (map) {
                Database.this.tables.put(table.getName(), table);
            }
            if (Database.this.logger.isLoggable(Level.FINE)) {
                Database.this.logger.fine("Found details of table " + table.getName());
            } else {
                System.out.print('.');
            }
        }

        void join() {
        }
    }

    private class BasicTableMeta {
        final String schema;
        final String name;
        final String type;
        final String remarks;
        final String viewSql;
        final int numRows;

        BasicTableMeta(String schema, String name, String type, String remarks, String text, int numRows) {
            this.schema = schema;
            this.name = name;
            this.type = type;
            this.remarks = remarks;
            this.viewSql = text;
            this.numRows = numRows;
        }
    }

    class NameValidator {
        private final String clazz;
        private final Pattern include;
        private final Pattern exclude;
        private final Set<String> validTypes;

        NameValidator(String clazz, Pattern include, Pattern exclude, String[] validTypes) {
            this.clazz = clazz;
            this.include = include;
            this.exclude = exclude;
            this.validTypes = new HashSet<String>();
            for (String type : validTypes) {
                this.validTypes.add(type.toUpperCase());
            }
        }

        boolean isValid(String name, String type) {
            if (!this.validTypes.contains(type.toUpperCase())) {
                return false;
            }
            if (name.indexOf("$") != -1) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + name + ": embedded $ implies illegal name");
                }
                return false;
            }
            if (this.exclude.matcher(name).matches()) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + name + ": matches exclusion pattern \"" + this.exclude + '\"');
                }
                return false;
            }
            boolean valid = this.include.matcher(name).matches();
            if (Database.this.fineEnabled) {
                if (valid) {
                    Database.this.logger.fine("Including " + this.clazz + " " + name + ": matches inclusion pattern \"" + this.include + '\"');
                } else {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + name + ": doesn't match inclusion pattern \"" + this.include + '\"');
                }
            }
            return valid;
        }
    }
}

