/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;

public class ForeignKeyConstraint
implements Comparable<ForeignKeyConstraint> {
    private final String name;
    private Table parentTable;
    private final List<TableColumn> parentColumns = new ArrayList<TableColumn>();
    private final Table childTable;
    private final List<TableColumn> childColumns = new ArrayList<TableColumn>();
    private final int deleteRule;
    private final int updateRule;
    private static final Logger logger = Logger.getLogger(ForeignKeyConstraint.class.getName());
    private static final boolean finerEnabled = logger.isLoggable(Level.FINER);

    ForeignKeyConstraint(Table child, String name, int updateRule, int deleteRule) {
        this.name = name;
        if (finerEnabled) {
            logger.finer("Adding foreign key constraint '" + this.getName() + "' to " + child);
        }
        this.childTable = child;
        this.deleteRule = deleteRule;
        this.updateRule = updateRule;
    }

    public ForeignKeyConstraint(TableColumn parentColumn, TableColumn childColumn, int updateRule, int deleteRule) {
        this(childColumn.getTable(), null, updateRule, deleteRule);
        this.addChildColumn(childColumn);
        this.addParentColumn(parentColumn);
        childColumn.addParent(parentColumn, this);
        parentColumn.addChild(childColumn, this);
    }

    public ForeignKeyConstraint(TableColumn parentColumn, TableColumn childColumn) {
        this(parentColumn, childColumn, 3, 3);
    }

    void addParentColumn(TableColumn column) {
        if (column != null) {
            this.parentColumns.add(column);
            this.parentTable = column.getTable();
        }
    }

    void addChildColumn(TableColumn column) {
        if (column != null) {
            this.childColumns.add(column);
        }
    }

    public String getName() {
        return this.name;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public List<TableColumn> getParentColumns() {
        return Collections.unmodifiableList(this.parentColumns);
    }

    public Table getChildTable() {
        return this.childTable;
    }

    public List<TableColumn> getChildColumns() {
        return Collections.unmodifiableList(this.childColumns);
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public boolean isCascadeOnDelete() {
        return this.getDeleteRule() == 0;
    }

    public boolean isRestrictDelete() {
        return this.getDeleteRule() == 3 || this.getDeleteRule() == 1;
    }

    public boolean isNullOnDelete() {
        return this.getDeleteRule() == 2;
    }

    public String getDeleteRuleName() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete";
            }
            case 1: 
            case 3: {
                return "Restrict delete";
            }
            case 2: {
                return "Null on delete";
            }
        }
        return "";
    }

    public String getDeleteRuleDescription() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete:\n Deletion of parent deletes child";
            }
            case 1: 
            case 3: {
                return "Restrict delete:\n Parent cannot be deleted if children exist";
            }
            case 2: {
                return "Null on delete:\n Foreign key to parent set to NULL when parent deleted";
            }
        }
        return "";
    }

    public String getDeleteRuleAlias() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "C";
            }
            case 1: 
            case 3: {
                return "R";
            }
            case 2: {
                return "N";
            }
        }
        return "";
    }

    public int getUpdateRule() {
        return this.updateRule;
    }

    public boolean isImplied() {
        return false;
    }

    public boolean isReal() {
        return this.getClass() == ForeignKeyConstraint.class;
    }

    @Override
    public int compareTo(ForeignKeyConstraint other) {
        if (other == this) {
            return 0;
        }
        int rc = this.getName().compareToIgnoreCase(other.getName());
        if (rc == 0) {
            String ours = this.getChildColumns().get(0).getTable().getSchema();
            String theirs = other.getChildColumns().get(0).getTable().getSchema();
            rc = ours != null && theirs != null ? ours.compareToIgnoreCase(theirs) : (ours == null ? -1 : 1);
        }
        return rc;
    }

    public static String toString(List<TableColumn> columns) {
        if (columns.size() == 1) {
            return columns.iterator().next().toString();
        }
        return columns.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.childTable.getName());
        buf.append('.');
        buf.append(ForeignKeyConstraint.toString(this.childColumns));
        buf.append(" refs ");
        buf.append(this.parentTable.getName());
        buf.append('.');
        buf.append(ForeignKeyConstraint.toString(this.parentColumns));
        if (this.parentTable.isRemote()) {
            buf.append(" in ");
            buf.append(this.parentTable.getSchema());
        }
        if (this.name != null) {
            buf.append(" via ");
            buf.append(this.name);
        }
        return buf.toString();
    }
}

