/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.schemaspy.model.TableColumn;

public class TableIndex
implements Comparable<TableIndex> {
    private final String name;
    private final boolean isUnique;
    private Object id;
    private boolean isPrimary;
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private final List<Boolean> columnsAscending = new ArrayList<Boolean>();

    public TableIndex(ResultSet rs) throws SQLException {
        this.name = rs.getString("INDEX_NAME");
        this.isUnique = !rs.getBoolean("NON_UNIQUE");
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void addColumn(TableColumn column, String sortOrder) {
        if (column != null) {
            this.columns.add(column);
            this.columnsAscending.add(sortOrder == null || sortOrder.equals("A"));
        }
    }

    public String getType() {
        if (this.isPrimaryKey()) {
            return "Primary key";
        }
        if (this.isUnique()) {
            return "Must be unique";
        }
        return "Performance";
    }

    public boolean isPrimaryKey() {
        return this.isPrimary;
    }

    public void setIsPrimaryKey(boolean isPrimaryKey) {
        this.isPrimary = isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getColumnsAsString() {
        StringBuilder buf = new StringBuilder();
        for (TableColumn column : this.columns) {
            if (buf.length() > 0) {
                buf.append(" + ");
            }
            buf.append(column);
        }
        return buf.toString();
    }

    public List<TableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean isUniqueNullable() {
        TableColumn column;
        if (!this.isUnique()) {
            return false;
        }
        boolean allNullable = true;
        Iterator<TableColumn> iterator = this.getColumns().iterator();
        while (iterator.hasNext() && (allNullable = (column = iterator.next()) != null && column.isNullable())) {
        }
        return allNullable;
    }

    public boolean isAscending(TableColumn column) {
        return this.columnsAscending.get(this.columns.indexOf(column));
    }

    @Override
    public int compareTo(TableIndex other) {
        if (this.isPrimaryKey() && !other.isPrimaryKey()) {
            return -1;
        }
        if (!this.isPrimaryKey() && other.isPrimaryKey()) {
            return 1;
        }
        Object thisId = this.getId();
        Object otherId = other.getId();
        if (thisId == null || otherId == null) {
            return this.getName().compareToIgnoreCase(other.getName());
        }
        if (thisId instanceof Number) {
            return ((Number)thisId).intValue() - ((Number)otherId).intValue();
        }
        return thisId.toString().compareToIgnoreCase(otherId.toString());
    }
}

