/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ForeignKeyMeta {
    private final String tableName;
    private final String columnName;
    private final String remoteSchema;
    private static final Logger logger = Logger.getLogger(ForeignKeyMeta.class.getName());

    ForeignKeyMeta(Node foreignKeyNode) {
        NamedNodeMap attribs = foreignKeyNode.getAttributes();
        Node node = attribs.getNamedItem("table");
        if (node == null) {
            throw new IllegalStateException("XML foreignKey definition requires 'table' attribute");
        }
        this.tableName = node.getNodeValue();
        node = attribs.getNamedItem("column");
        if (node == null) {
            throw new IllegalStateException("XML foreignKey definition requires 'column' attribute");
        }
        this.columnName = node.getNodeValue();
        node = attribs.getNamedItem("remoteSchema");
        this.remoteSchema = node != null ? node.getNodeValue() : null;
        logger.finer("Found XML FK metadata for " + this.tableName + "." + this.columnName + " remoteSchema: " + this.remoteSchema);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getRemoteSchema() {
        return this.remoteSchema;
    }

    public String toString() {
        return this.tableName + '.' + this.columnName;
    }
}

