/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchemaMeta {
    private final List<TableMeta> tables = new ArrayList<TableMeta>();
    private final String comments;
    private final File metaFile;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public SchemaMeta(String xmlMeta, String dbName, String schema) throws InvalidConfigurationException {
        File meta = new File(xmlMeta);
        if (meta.isDirectory()) {
            String filename = (schema == null ? dbName : schema) + ".meta.xml";
            if (!(meta = new File(meta, filename)).exists()) {
                if (Config.getInstance().isOneOfMultipleSchemas()) {
                    this.logger.info("Meta directory \"" + xmlMeta + "\" should contain a file named \"" + filename + '\"');
                    this.comments = null;
                    this.metaFile = null;
                    return;
                }
                throw new InvalidConfigurationException("Meta directory \"" + xmlMeta + "\" must contain a file named \"" + filename + '\"');
            }
        } else if (!meta.exists()) {
            throw new InvalidConfigurationException("Specified meta file \"" + xmlMeta + "\" does not exist");
        }
        this.metaFile = meta;
        Document doc = this.parse(this.metaFile);
        NodeList commentsNodes = doc.getElementsByTagName("comments");
        this.comments = commentsNodes != null && commentsNodes.getLength() > 0 ? commentsNodes.item(0).getTextContent() : null;
        NodeList tablesNodes = doc.getElementsByTagName("tables");
        if (tablesNodes != null) {
            NodeList tableNodes = ((Element)tablesNodes.item(0)).getElementsByTagName("table");
            for (int i = 0; i < tableNodes.getLength(); ++i) {
                Node tableNode = tableNodes.item(i);
                TableMeta tableMeta = new TableMeta(tableNode);
                this.tables.add(tableMeta);
            }
        }
    }

    public String getComments() {
        return this.comments;
    }

    public File getFile() {
        return this.metaFile;
    }

    public List<TableMeta> getTables() {
        return this.tables;
    }

    private void validate(Document document) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream xsl = this.getClass().getResourceAsStream("/schemaspy.meta.xsd");
        Schema schema = factory.newSchema(new StreamSource(xsl));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    private Document parse(File file) throws InvalidConfigurationException {
        DocumentBuilder docBuilder;
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new InvalidConfigurationException("Invalid XML parser configuration", exc);
        }
        try {
            doc = docBuilder.parse(file);
            this.validate(doc);
        }
        catch (SAXException exc) {
            throw new InvalidConfigurationException(file + " failed XML validation:", exc);
        }
        catch (IOException exc) {
            throw new InvalidConfigurationException("Could not read " + file + ":", exc);
        }
        return doc;
    }
}

