/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.schemaspy.ui.DbConfigTableModel;
import net.sourceforge.schemaspy.ui.DbTypeSelectorModel;
import net.sourceforge.schemaspy.ui.DirectoryCellEditor;
import net.sourceforge.schemaspy.ui.UiUtils;
import net.sourceforge.schemaspy.util.DbSpecificConfig;

public class DbConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox databaseTypeSelector;
    private final DbConfigTableModel model = new DbConfigTableModel();
    private JTable table;

    public DbConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;
            {
                this.setDefaultRenderer(Boolean.TYPE, this.getDefaultRenderer(Boolean.class));
                this.setDefaultEditor(Boolean.TYPE, this.getDefaultEditor(Boolean.class));
                this.setDefaultRenderer(Number.class, this.getDefaultRenderer(String.class));
                this.setDefaultEditor(Number.class, this.getDefaultEditor(String.class));
                DirectoryCellEditor fileEditor = new DirectoryCellEditor(DbConfigPanel.this.model, new File("/"));
                this.setDefaultRenderer(File.class, fileEditor);
                this.setDefaultEditor(File.class, fileEditor);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                TableCellRenderer renderer = column == 0 ? super.getCellRenderer(row, column) : this.getDefaultRenderer(DbConfigPanel.this.model.getClass(row));
                if (renderer instanceof JComponent) {
                    ((JComponent)((Object)renderer)).setToolTipText(DbConfigPanel.this.model.getDescription(row));
                }
                return renderer;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                return this.getDefaultEditor(DbConfigPanel.this.model.getClass(row));
            }
        };
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableColumn paramColumn = DbConfigPanel.this.table.getColumnModel().getColumn(0);
                paramColumn.setPreferredWidth(UiUtils.getPreferredColumnWidth(DbConfigPanel.this.table, paramColumn) + 4);
                paramColumn.setMaxWidth(paramColumn.getPreferredWidth());
                DbConfigPanel.this.table.sizeColumnsToFit(0);
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setViewportBorder(null);
        this.add((Component)scroller, "Center");
        this.add((Component)this.getDatabaseTypeSelector(), "North");
    }

    private JComboBox getDatabaseTypeSelector() {
        if (this.databaseTypeSelector == null) {
            DbTypeSelectorModel selectorModel = new DbTypeSelectorModel("ora");
            this.databaseTypeSelector = new JComboBox(selectorModel);
            this.databaseTypeSelector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        DbConfigPanel.this.model.setDbSpecificConfig((DbSpecificConfig)evt.getItem());
                    }
                }
            });
            DbSpecificConfig selected = (DbSpecificConfig)selectorModel.getSelectedItem();
            if (selected != null) {
                this.model.setDbSpecificConfig(selected);
            }
        }
        return this.databaseTypeSelector;
    }
}

