/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.DbSpecificOption;

public class DbConfigTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final List<PropertyDescriptor> options = new ArrayList<PropertyDescriptor>();
    private Config config = Config.getInstance();

    public DbConfigTableModel() {
        PropertyDescriptor[] props = this.getConfigProps();
        this.options.add(this.getDescriptor("outputDir", "Directory to generate HTML output to", props));
        this.options.add(this.getDescriptor("schema", "Schema to evaluate", props));
        this.options.add(this.getDescriptor("user", "User ID to connect with", props));
        this.options.add(this.getDescriptor("password", "Password associated with user id", props));
        this.options.add(this.getDescriptor("impliedConstraintsEnabled", "XXXX", props));
    }

    public void setDbSpecificConfig(DbSpecificConfig dbConfig) {
        this.config = dbConfig.getConfig();
        Config.setInstance(this.config);
        PropertyDescriptor[] props = this.getConfigProps();
        this.removeDbSpecificOptions();
        for (DbSpecificOption option : dbConfig.getOptions()) {
            PropertyDescriptor descriptor = this.getDescriptor(option.getName(), option.getDescription(), props);
            descriptor.setValue("dbSpecific", Boolean.TRUE);
            this.options.add(descriptor);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Option";
            }
        }
        return "Value";
    }

    private PropertyDescriptor getDescriptor(String propName, String description, PropertyDescriptor[] props) {
        if (props == null) {
            props = this.getConfigProps();
        }
        for (int i = 0; i < props.length; ++i) {
            PropertyDescriptor prop = props[i];
            if (!prop.getName().equalsIgnoreCase(propName)) continue;
            prop.setShortDescription(description);
            return prop;
        }
        throw new IllegalArgumentException(propName + " is not a valid configuration item");
    }

    private PropertyDescriptor[] getConfigProps() throws RuntimeException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(Config.class);
        }
        catch (IntrospectionException exc) {
            throw new RuntimeException(exc);
        }
        return beanInfo.getPropertyDescriptors();
    }

    private void removeDbSpecificOptions() {
        Iterator<PropertyDescriptor> iter = this.options.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor descriptor = iter.next();
            if (descriptor.getValue("dbSpecific") == null) continue;
            iter.remove();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.options.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col != 1) {
            return false;
        }
        return this.options.get(row).getWriteMethod() != null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        PropertyDescriptor descriptor = this.options.get(row);
        switch (column) {
            case 0: {
                return descriptor.getName();
            }
            case 1: {
                try {
                    Object value = descriptor.getReadMethod().invoke((Object)this.config, (Object[])null);
                    return value;
                }
                catch (InvocationTargetException exc) {
                    if (exc.getCause() instanceof Config.MissingRequiredParameterException) {
                        return null;
                    }
                    throw new RuntimeException(exc);
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object oldValue = this.getValueAt(row, col);
        if (!(oldValue == value || value != null && oldValue != null && value.equals(oldValue))) {
            PropertyDescriptor descriptor = this.options.get(row);
            try {
                if (value instanceof String && descriptor.getPropertyType().isAssignableFrom(Integer.class)) {
                    try {
                        value = Integer.valueOf((String)value);
                    }
                    catch (NumberFormatException nfe) {
                        value = oldValue;
                    }
                }
                descriptor.getWriteMethod().invoke((Object)this.config, value);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public Class<?> getClass(int row) {
        PropertyDescriptor descriptor = this.options.get(row);
        return descriptor.getPropertyType();
    }

    public String getDescription(int row) {
        PropertyDescriptor descriptor = this.options.get(row);
        return descriptor.getShortDescription();
    }
}

