/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificOption;

public class DbSpecificConfig {
    private final String type;
    private String description;
    private final List<DbSpecificOption> options = new ArrayList<DbSpecificOption>();
    private final Config config = new Config();

    public DbSpecificConfig(String dbType) {
        this.type = dbType;
        try {
            Properties props = this.config.getDbProperties(dbType);
            this.description = props.getProperty("description");
            this.loadOptions(props);
        }
        catch (IOException exc) {
            this.description = exc.toString();
        }
    }

    private void loadOptions(Properties properties) {
        boolean inParam = false;
        StringTokenizer tokenizer = new StringTokenizer(properties.getProperty("connectionSpec"), "<>", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("<")) {
                inParam = true;
                continue;
            }
            if (token.equals(">")) {
                inParam = false;
                continue;
            }
            if (!inParam) continue;
            String desc = properties.getProperty(token);
            this.options.add(new DbSpecificOption(token, desc));
        }
    }

    public List<DbSpecificOption> getOptions() {
        return this.options;
    }

    public Config getConfig() {
        return this.config;
    }

    public void dumpUsage() {
        System.out.println(" " + new File(this.type).getName() + ":");
        System.out.println("  " + this.description);
        for (DbSpecificOption option : this.getOptions()) {
            System.out.println("   -" + option.getName() + " " + (option.getDescription() != null ? "  \t" + option.getDescription() : ""));
        }
    }

    public String toString() {
        return this.description;
    }
}

