/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.Version;

public class Dot {
    private static Dot instance = new Dot();
    private final Version version;
    private final Version supportedVersion;
    private final Version badVersion;
    private final String lineSeparator;
    private String dotExe;
    private String format;
    private String renderer;
    private final Set<String> validatedRenderers;
    private final Set<String> invalidatedRenderers;

    private Dot() {
        String versionText;
        block5: {
            this.supportedVersion = new Version("2.2.1");
            this.badVersion = new Version("2.4");
            this.lineSeparator = System.getProperty("line.separator");
            this.format = "png";
            this.validatedRenderers = Collections.synchronizedSet(new HashSet());
            this.invalidatedRenderers = Collections.synchronizedSet(new HashSet());
            versionText = null;
            String[] dotCommand = new String[]{this.getExe(), "-V"};
            try {
                Process process = Runtime.getRuntime().exec(dotCommand);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String versionLine = reader.readLine();
                Matcher matcher = Pattern.compile("[0-9][0-9.]+").matcher(versionLine);
                if (matcher.find()) {
                    versionText = matcher.group();
                } else if (Config.getInstance().isHtmlGenerationEnabled()) {
                    System.err.println();
                    System.err.println("Invalid dot configuration detected.  '" + Dot.getDisplayableCommand(dotCommand) + "' returned:");
                    System.err.println("   " + versionLine);
                }
            }
            catch (Exception validDotDoesntExist) {
                if (!Config.getInstance().isHtmlGenerationEnabled()) break block5;
                System.err.println("Failed to query Graphviz version information");
                System.err.println("  with: " + Dot.getDisplayableCommand(dotCommand));
                System.err.println("  " + validDotDoesntExist);
            }
        }
        this.version = new Version(versionText);
    }

    public static Dot getInstance() {
        return instance;
    }

    public boolean exists() {
        return this.version.toString() != null;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isValid() {
        return this.exists() && (this.getVersion().equals(this.supportedVersion) || this.getVersion().compareTo(this.badVersion) > 0);
    }

    public String getSupportedVersions() {
        return "dot version " + this.supportedVersion + " or versions greater than " + this.badVersion;
    }

    public boolean supportsCenteredEastWestEdges() {
        return this.getVersion().compareTo(new Version("2.6")) >= 0;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean requiresGdRenderer() {
        return this.getVersion().compareTo(new Version("2.12")) >= 0 && this.supportsRenderer(":gd");
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public String getRenderer() {
        return this.renderer != null && this.supportsRenderer(this.renderer) ? this.renderer : (this.requiresGdRenderer() ? ":gd" : "");
    }

    public void setHighQuality(boolean highQuality) {
        if (highQuality && this.supportsRenderer(":cairo")) {
            this.setRenderer(":cairo");
        } else if (this.supportsRenderer(":gd")) {
            this.setRenderer(":gd");
        }
    }

    public boolean isHighQuality() {
        return this.getRenderer().indexOf(":cairo") != -1;
    }

    public boolean supportsRenderer(String renderer) {
        if (!this.exists()) {
            return false;
        }
        if (this.validatedRenderers.contains(renderer)) {
            return true;
        }
        if (this.invalidatedRenderers.contains(renderer)) {
            return false;
        }
        try {
            String line;
            String[] dotCommand = new String[]{this.getExe(), "-T" + this.getFormat() + ':'};
            Process process = Runtime.getRuntime().exec(dotCommand);
            BufferedReader errors = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = errors.readLine()) != null) {
                if (!line.contains(this.getFormat() + renderer)) continue;
                this.validatedRenderers.add(renderer);
            }
            process.waitFor();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (!this.validatedRenderers.contains(renderer)) {
            this.invalidatedRenderers.add(renderer);
            return false;
        }
        return true;
    }

    private String getExe() {
        if (this.dotExe == null) {
            File gv = Config.getInstance().getGraphvizDir();
            this.dotExe = gv == null ? "dot" : new File(new File(gv, "bin"), "dot").toString();
        }
        return this.dotExe;
    }

    public String generateDiagram(File dotFile, File diagramFile) throws DotFailure {
        StringBuilder mapBuffer = new StringBuilder(1024);
        BufferedReader mapReader = null;
        String[] dotCommand = new String[]{this.getExe(), "-T" + this.getFormat() + this.getRenderer(), dotFile.toString(), "-o" + diagramFile, "-Tcmapx"};
        String commandLine = Dot.getDisplayableCommand(dotCommand);
        try {
            String line;
            Process process = Runtime.getRuntime().exec(dotCommand);
            new ProcessOutputReader(commandLine, process.getErrorStream()).start();
            mapReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = mapReader.readLine()) != null) {
                mapBuffer.append(line);
                mapBuffer.append(this.lineSeparator);
            }
            int rc = process.waitFor();
            if (rc != 0) {
                throw new DotFailure("'" + commandLine + "' failed with return code " + rc);
            }
            if (!diagramFile.exists()) {
                throw new DotFailure("'" + commandLine + "' failed to create output file");
            }
            String string = mapBuffer.toString().replace("/>", ">");
            return string;
        }
        catch (InterruptedException interrupted) {
            throw new RuntimeException(interrupted);
        }
        catch (DotFailure failed) {
            diagramFile.delete();
            throw failed;
        }
        catch (IOException failed) {
            diagramFile.delete();
            throw new DotFailure("'" + commandLine + "' failed with exception " + failed);
        }
        finally {
            if (mapReader != null) {
                try {
                    mapReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getDisplayableCommand(String[] command) {
        StringBuilder displayable = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            displayable.append(command[i]);
            if (i + 1 >= command.length) continue;
            displayable.append(' ');
        }
        return displayable.toString();
    }

    private static class ProcessOutputReader
    extends Thread {
        private final BufferedReader processReader;
        private final String command;

        ProcessOutputReader(String command, InputStream processStream) {
            this.processReader = new BufferedReader(new InputStreamReader(processStream));
            this.command = command;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.processReader.readLine()) != null) {
                    if (line.indexOf("unrecognized") != -1 || line.indexOf("port") != -1) continue;
                    System.err.println(this.command + ": " + line);
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            finally {
                try {
                    this.processReader.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    public class DotFailure
    extends IOException {
        private static final long serialVersionUID = 3833743270181351987L;

        public DotFailure(String msg) {
            super(msg);
        }
    }
}

