/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class LineWriter
extends BufferedWriter {
    private final Writer out;

    public LineWriter(String filename, String charset) throws UnsupportedEncodingException, FileNotFoundException {
        this(new FileOutputStream(filename), charset);
    }

    public LineWriter(String filename, int sz, String charset) throws UnsupportedEncodingException, FileNotFoundException {
        this(new FileOutputStream(filename), sz, charset);
    }

    public LineWriter(File file, String charset) throws UnsupportedEncodingException, FileNotFoundException {
        this(new FileOutputStream(file), charset);
    }

    public LineWriter(File file, int sz, String charset) throws UnsupportedEncodingException, IOException {
        this(new FileOutputStream(file), sz, charset);
    }

    public LineWriter(OutputStream out, String charset) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(out, charset), 8192);
    }

    public LineWriter(OutputStream out, int sz, String charset) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(out, charset), sz);
    }

    private LineWriter(Writer out, int sz) {
        super(out, sz);
        this.out = out;
    }

    public void writeln(String str) throws IOException {
        this.write(str);
        this.newLine();
    }

    public void writeln() throws IOException {
        this.newLine();
    }

    public String toString() {
        try {
            this.flush();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        return this.out.toString();
    }
}

