/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ren.crux.common.CommonProperties;
import ren.crux.common.util.ApplicationContextHelper;
import ren.crux.common.util.ConfigurationParser;

@Configuration
@EnableConfigurationProperties
public class CommonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CommonAutoConfiguration.class);

    @Autowired
    public CommonAutoConfiguration(ApplicationContext context) {
        log.trace("Application context id : {}", (Object)context.getId());
        ApplicationContextHelper.set(context);
    }

    @Bean
    @ConditionalOnMissingBean
    public CommonProperties commonProperties() {
        return new CommonProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationParser configurationParser(ApplicationContext context) {
        return new ConfigurationParser(context);
    }
}

