/*
 * Decompiled with CFR 0.152.
 */
package ren.crux.common.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import ren.crux.common.CommonConstants;

public class ConfigurationParser {
    private final ApplicationContext applicationContext;

    public ConfigurationParser(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Properties yamlResources2Properties(Resource ... resources) {
        YamlPropertiesFactoryBean yamlPropertiesFactoryBean = new YamlPropertiesFactoryBean();
        yamlPropertiesFactoryBean.setResources(resources);
        return yamlPropertiesFactoryBean.getObject();
    }

    public Properties yamlBytes2Properties(byte[] bytes) {
        return this.yamlResources2Properties(new Resource[]{new ByteArrayResource(bytes)});
    }

    public Properties bytes2Properties(byte[] bytes) throws IOException {
        Properties properties = new Properties();
        StringReader reader = new StringReader(new String(bytes, CommonConstants.UTF_8_CHARSET));
        properties.load(reader);
        return properties;
    }

    public <T> T bind(@NonNull T instance, PlaceholdersResolver placeholdersResolver, ConfigurationPropertySource ... sources) {
        if (instance == null) {
            throw new NullPointerException("instance is marked @NonNull but is null");
        }
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(instance.getClass(), ConfigurationProperties.class);
        Binder binder = new Binder(Arrays.asList(sources), placeholdersResolver);
        return (T)binder.bind(annotation.prefix(), Bindable.ofInstance(instance)).get();
    }

    public <T> T bind(@NonNull T instance, Properties properties) {
        if (instance == null) {
            throw new NullPointerException("instance is marked @NonNull but is null");
        }
        PropertySourcesPlaceholdersResolver placeholdersResolver = new PropertySourcesPlaceholdersResolver(this.applicationContext.getEnvironment());
        MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)properties);
        return this.bind(instance, (PlaceholdersResolver)placeholdersResolver, new ConfigurationPropertySource[]{source});
    }

    public <T> T parse(@NonNull Class<T> cls, PlaceholdersResolver placeholdersResolver, ConfigurationPropertySource ... sources) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(cls, ConfigurationProperties.class);
        Binder binder = new Binder(Arrays.asList(sources), placeholdersResolver);
        return (T)binder.bind(annotation.prefix(), Bindable.of(cls), this.getBindHandler(annotation)).get();
    }

    public <T> T parse(@NonNull Class<T> cls, Properties properties) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)properties);
        PropertySourcesPlaceholdersResolver placeholdersResolver = new PropertySourcesPlaceholdersResolver(this.applicationContext.getEnvironment());
        return this.parse(cls, (PlaceholdersResolver)placeholdersResolver, new ConfigurationPropertySource[]{source});
    }

    private BindHandler getBindHandler(ConfigurationProperties annotation) {
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        if (annotation.ignoreInvalidFields()) {
            handler = new IgnoreErrorsBindHandler((BindHandler)handler);
        }
        if (!annotation.ignoreUnknownFields()) {
            UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
            handler = new NoUnboundElementsBindHandler((BindHandler)handler, (Function)filter);
        }
        return handler;
    }
}

