/*
 *
 *    Copyright 2018 The Crux Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package ren.crux.web.common;

import lombok.Data;

import java.io.Serializable;

/**
 * An Container for Restful  Style Result
 *
 * @author wangzhihui
 */
@Data
public class RestWebResultContainer implements Serializable {

    private static final long serialVersionUID = 1330654629886381304L;
    private int code;
    private String msg;
    private Object data;

    public RestWebResultContainer() {
    }

    public RestWebResultContainer(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public RestWebResultContainer(int code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
}
